% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{cardinal_cubic_hermite}
\alias{cardinal_cubic_hermite}
\title{Cardinal Cubic Hermite Interpolator}
\usage{
cardinal_cubic_hermite(y, dydx, x0, dx)
}
\arguments{
\item{y}{Numeric vector of ordinates (y-coordinates).}

\item{dydx}{Numeric vector of derivatives (slopes) at each point.}

\item{x0}{Numeric value of the first abscissa (x-coordinate).}

\item{dx}{Numeric value of the spacing between abscissas.}
}
\value{
An object of class \code{cardinal_cubic_hermite} with methods:
\itemize{
\item \code{spline(xi)}: Evaluate the interpolator at point \code{xi}.
\item \code{prime(xi)}: Evaluate the derivative of the interpolator at point \code{xi}.
\item \code{domain()}: Get the domain of the interpolator.
}
}
\description{
Constructs a cardinal cubic Hermite interpolator given the vectors of abscissas, ordinates, and derivatives.
}
\examples{
y <- c(0, 1, 0)
dydx <- c(1, 0, -1)
interpolator <- cardinal_cubic_hermite(y, dydx, 0, 1)
xi <- 0.5
interpolator$spline(xi)
interpolator$prime(xi)
interpolator$domain()
}
