% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mount.wl.bl.list.R
\name{mount.wl.bl.list}
\alias{mount.wl.bl.list}
\title{Mounts a white or black list}
\usage{
mount.wl.bl.list(vlist)
}
\arguments{
\item{vlist}{is a list of couple of variables.}
}
\value{
A new data frame with the 'from' and to 'to' variables.
}
\description{
Using a list of variables passed as parameter this function mounts a white list or a black list in bnlearn package sintax.
}
\details{
This function receives a list with one or more couple of variables and mount a new data frame in "bnlearn"
syntax. The final result must return an object similar to "data.frame(from = c('B', 'F'), to = c('F', 'B'))"
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
library(bnlearn)
# Load data sets from package
data.to.work<-dataQuantC
head(data.to.work)
###################################################################################
# mount.wl.bl.list.R - Mounts a white or black list.
###################################################################################
# Mounting the black list
vlist <- ("A-C,D-F")
bl <- mount.wl.bl.list(vlist)
# Mounting the white list
vlist <- ("A-B,D-G")
wl <- mount.wl.bl.list(vlist)
# Learn the Bayesian Networks structure without black and white list
bn.structure <- hc(data.to.work, whitelist = wl, blacklist = bl)
# Set the name of a text to save the Bayesian Networks parameters
param.name <- "docbnparamHC.txt"
# Generates a Bayesian Networks parameters from the Bayesian Networks structure and 
# write a text file with this
bn.param <- gera.bn.param(bn.structure, data.to.work, param.name)
# Set the graph name
graph.name <- "imgBNHC"
# Save the graph
mount.graph(bn.structure, bn.param, graph.name, data.to.work)
}
\author{
Elias Carvalho
}

