% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ume.network.R
\name{summary.ume.network.result}
\alias{summary.ume.network.result}
\title{Summarize result run by \code{\link{ume.network.run}}}
\usage{
\method{summary}{ume.network.result}(object, ...)
}
\arguments{
\item{object}{Result object created by \code{\link{ume.network.run}} function}

\item{...}{Additional arguments affecting the summary produced}
}
\value{
Returns summary of the ume network model result
}
\description{
This function uses summary function in coda package to summarize mcmc.list object. Monte carlo error (Time-series SE) is also obtained using the coda package and is printed in the summary as a default.
}
\examples{
network <- with(smoking, {
 ume.network.data(Outcomes, Study, Treat, N = N, response = "binomial", type = "random")
})
\donttest{
result <- ume.network.run(network) 
summary(result)
}
}
