% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap-mlr.R
\name{as_mlr}
\alias{as_mlr}
\title{Convert to \code{mlr}.}
\usage{
as_mlr(x, dag, id = "1")
}
\arguments{
\item{x}{A \code{\link{bnc_bn}} object.}

\item{dag}{A logical. Whether to learn structure on each training subsample. 
Parameters are always learned.}

\item{id}{A character.}
}
\description{
Convert a \code{\link{bnc_bn}} to a \code{\link[mlr]{Learner}}
object.
}
\examples{
data(car)
nb <- bnc('nb', 'class', car, smooth = 1)
\dontrun{library(mlr)}
\dontrun{nb_mlr <- as_mlr(nb, dag = FALSE, id = "ode_cl_aic")}
\dontrun{nb_mlr}
}
