% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomialfreq.R
\name{binomialfreq}
\alias{binomialfreq}
\title{Block Design for Response-Adaptive Randomization for Binomial Data}
\usage{
binomialfreq(p_control, p_treatment, N_total, block_number = 4,
  drift = 0, simulation = 10000, conf_int = 0.95,
  alternative = "greater", correct = FALSE, replace = TRUE,
  early_stop = FALSE, size_equal_randomization = 20,
  min_patient_earlystop = 20, max_prob = 0.8)
}
\arguments{
\item{p_control}{scalar. Proportion of events under the control arm.}

\item{p_treatment}{scalar. Proportion of events under the treatment arm.}

\item{N_total}{scalar. Total sample size.}

\item{block_number}{scalar. Number of blocks or time levels. The default is set to 4.
If \code{block_number} is set to 1. This is a traditional RCT design.}

\item{drift}{scalar. The increase or decrease in proportion of event over time.
In this case, the proportion of failure changes in each block by the number of
patient accured over the total sample size. The full drift effect is seen in the
final block.}

\item{simulation}{scalar. Number of simulation to be ran. The default is set to 10000.}

\item{conf_int}{scalar. Confidence level of the interval.}

\item{alternative}{character. A string specifying the alternative hypothesis,
must be one of "less" or "greater" (default).}

\item{correct}{logical. A logical indicating whether to apply continuity correction
when computing the test statistic: one half is subtracted from all |O - E|
differences; however, the correction will not be bigger than the differences themselves.}

\item{replace}{logical. should sampling be with replacement? If replace is set to
FALSE (default), the 0 for control, 1 for treatment is replicated to the closest
integer and this vector is sampled with no replacement. If replace is set to TRUE,
the sampling is done based on randomization ratio provided with replacement.}

\item{early_stop}{logical. A logical indicating whether the trials are stopped early
for success or futility.}

\item{size_equal_randomization}{scalar. The number of run in patients because adaptive
randomization is applied.}

\item{min_patient_earlystop}{scalar. Minimum number of patients before early stopping
rule is applied.}

\item{max_prob}{scalar. The maximum probability for assigning to treatment/control
group is 0.8.}
}
\value{
a list with details on the simulation.
\describe{
  \item{\code{power}}{
    scalar. The power of the trial, ie. the proportion of success over the
    number of simulation ran.}
  \item{\code{p_control_estimate}}{
    scalar. The estimated proportion of events under the control group.}
  \item{\code{p_treatment_estimate}}{
    scalar. The estimated proportion of events under the treatment group.}
  \item{\code{N_enrolled}}{
    vector. The number of patients enrolled in the trial (sum of control
    and experimental group for each simulation. )}
  \item{\code{N_control}}{
    vector. The number of patients enrolled in the control group for
    each simulation.}
  \item{\code{N_control}}{
    vector. The number of patients enrolled in the experimental group for
    each simulation.}
  \item{\code{randomization_ratio}}{
    matrix. The randomization ratio allocated for each block.}
}
}
\description{
Simulation for binomial counts for block design for
   response-adaptive randomization with time as a confounding
}
\examples{
binomialfreq(p_control = 0.7, p_treatment = 0.65, N_total = 200,
            block_number = 2, simulation = 100)
binomialfreq(p_control = 0.5, p_treatment = 0.40, N_total = 200,
            block_number = 2, simulation = 100, drift = -0.15)
}
