% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{compute_beta_posterior_density}
\alias{compute_beta_posterior_density}
\title{compute_beta_posterior_density}
\usage{
compute_beta_posterior_density(beta_sample, param)
}
\arguments{
\item{beta_sample}{a matrix. Each row is a coefficient function computed from the
posterior sample.}

\item{param}{a list containing:
\describe{
\item{grid}{a numerical vector, the time points.}
\item{lims_estimate}{a numerical vector, the time points.}
\item{burnin}{an integer (optional), the number of iteration to drop from the Gibbs
      sample.}
\item{lims_kde}{an integer (optional), correspond to the \code{lims} option
      of the \code{kde2d} funtion.}
\item{new_grid}{a numerical vector (optional) to compute beta sample on a
      different grid.}
\item{thin}{an integer (optional) to thin the posterior sample.}
}}
}
\value{
An approximation of the posterior density on a two-dimensional grid
        (corresponds to the result of the \code{\link[=kde2d]{kde2d}} function).
}
\description{
Compute the posterior density of the coefficient function.
}
\details{
The posterior densities correponds to approximations of the marginal
         posterior distribitions (of beta(t) for each t).
         The sample is thinned in order to reduce the correlation and the
         computational time of the function \code{\link[=kde2d]{kde2d}}.
}
\examples{
\donttest{
library(RColorBrewer)
data(data1)
data(param1)
data(res_bliss1)
param1$grids <- data1$grids
param1$p <- sapply(data1$grids,length)
param1$Q <- length(data1$x)

density_estimate <- compute_beta_posterior_density(res_bliss1$beta_sample,param1)
}
}
