% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_amlps_plot.R
\name{plot.amlps}
\alias{plot.amlps}
\title{Plot smooth functions of an additive model object.}
\usage{
\method{plot}{amlps}(x, xp, smoo.index, cred.int = 0.95, plot.cred = TRUE,
     np = 100, fit.col = "blue", shade.col = "gray75", show.plot = TRUE,
     show.info = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{amlps}.}

\item{xp}{A numeric vector of grid values on which to compute a point estimate
and pointwise credible interval for the smooth function specified in
\code{smoo.index}. The components of \code{xp} must be within the range
of the observed covariate values for the corresponding smooth function.
Results will be displayed in a table.}

\item{smoo.index}{The index of the smooth function. For instance
\code{smoo.index = 2} refers to the second smooth function specified in
the \code{formula} of the \code{amlps} routine.}

\item{cred.int}{The level of the pointwise credible interval to be
computed for the smooth additive term. Default is \code{0.95}.}

\item{plot.cred}{Logical. Should the credible intervals be plotted?
Default is \code{TRUE}.}

\item{np}{The number of points used to construct the plot of the smooth
additive function. Default is 100 and allowed values are between 20 and
200.}

\item{fit.col}{The color of the fitted curve.}

\item{shade.col}{The shading color for the credible intervals.}

\item{show.plot}{Logical. Should the plot be displayed? Default is
\code{TRUE}.}

\item{show.info}{Logical. Should the table of point and set estimates of
the smooth function on the specified \code{xp} values be displayed? Default
is \code{TRUE}.}

\item{...}{Further arguments to be passed to \code{plot}.}
}
\value{
If \code{xp} is unspecified (the default), the routine will only
return a plot of the estimated smooth curve. Otherwise, it provides a
list with the following components:

\item{xp}{The chosen points on which to compute the smooth fit.}

\item{sm.xp}{The estimated smooth fit at points specified in \code{xp}.}

\item{sm.low}{The lower bound of the pointwise credible interval for the
 smooth additive function at points specified in \code{xp}.}

\item{sm.up}{The upper bound of the pointwise credible interval for the
 smooth additive function at points specified in \code{xp}.}

 \item{cred.int}{The chosen level to compute credible intervals.}

 \item{smoo.index}{The index of the smooth function.}
}
\description{
Displays a plot of the fitted additive smooth components of an
 \code{amlps} object. The routine can also be used to
 print a table of point and set estimates of an additive smooth term for a
 user-specified grid of values.
}
\details{
Produces a plot of a smooth additive term fitted with the
 \code{\link{amlps}} function. On the y-axis, the estimated effective
 dimension of the smooth term is also displayed. At the bottom of each
 plot, vertical ticks indicate the location of the covariate values. The
 labels on the x-axis correspond to the covariate name associated to the
 smooth term.
}
\examples{

### Classic simulated data example

set.seed(3)

sim.data <- simgamdata(setting = 2, n = 200, dist = "gaussian", scale = 0.3)
plot(sim.data)         # Scatter plot of response
data <- sim.data$data  # Simulated data frame

# Fit model
fit <- amlps(y ~ z1 + z2 + sm(x1) + sm(x2), data = data, K = 20)
fit

# Plot fit of second function and results for a specific grid x
plot(fit, xp = c(-0.8, -0.4, 0, 0.4, 0.8), smoo.index = 2, ylim=c(-3, 3))

}
\seealso{
\code{\link{amlps}}, \code{\link{amlps.object}},
 \code{\link{print.amlps}}
}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}.
}
