% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_funs.R
\name{predict.bkmrfit}
\alias{predict.bkmrfit}
\title{Posterior mean/sd predictions}
\usage{
\method{predict}{bkmrfit}(object, ptype = c("mean", "sd.fit"), ...)
}
\arguments{
\item{object}{fitted object of class inheriting from "bkmrfit".}

\item{ptype}{"mean" or "sd.fit", where "mean" yields posterior
mean prediction for every observation in the data, and "sd.fit"
yields the posterior standard deviation for every observation in
the data.}

\item{...}{arguments to \code{\link[bkmr]{SamplePred}}}
}
\value{
vector of predictions the same length as the outcome in the bkmrfit object
}
\description{
Provides observation level predictions based on the posterior mean, or, alternatively, yields the posterior standard deviations of predictions for an observation. This function is useful for interfacing with ensemble machine learning packages such as \code{SuperLearner}, which utilize only point estimates.
}
\examples{
# following example from https://jenfb.github.io/bkmr/overview.html
\donttest{
library(bkmr)
set.seed(111)
dat <- bkmr::SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X
set.seed(111)
fitkm <- kmbayes(y = y, Z = Z, X = X, iter = 200, verbose = FALSE,
  varsel = TRUE)
postmean = predict(fitkm)
postmean2 = predict(fitkm, Znew=Z/2)
# mean difference in posterior means
mean(postmean-postmean2)
}
}
