% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_pal.R
\name{bi_pal_manual}
\alias{bi_pal_manual}
\title{Create Manual Palette}
\usage{
bi_pal_manual(val_1_1, val_1_2, val_1_3, val_2_1, val_2_2, val_2_3,
    val_3_1, val_3_2, val_3_3, preview = FALSE)
}
\arguments{
\item{val_1_1}{A hex value for cell 1-1}

\item{val_1_2}{A hex value for cell 1-2}

\item{val_1_3}{A hex value for cell 1-3}

\item{val_2_1}{A hex value for cell 2-1}

\item{val_2_2}{A hex value for cell 2-2}

\item{val_2_3}{A hex value for cell 2-3}

\item{val_3_1}{A hex value for cell 3-1}

\item{val_3_2}{A hex value for cell 3-2}

\item{val_3_3}{A hex value for cell 3-3}

\item{preview}{A logical scalar; if \code{TRUE} (default), an image preview will
be generated. If \code{FALSE}, a vector with hex color values will be returned.}
}
\description{
A function for structuring manual bi-variate palettes. All values must be entered
    as six-digit hex values (e.g. #000000) and must be preceded by the number symbol. Short
    forms of hex values (e.g. #000) are not accepted as valid inputs. For two-by-two palettes,
    only the 'val_1_1', 'val_1_2', 'val_2_1', and 'val_2_2' parameters are required. For
    three-by-three palettes, all parameters are required.
}
\examples{
custom_pal <- bi_pal_manual(val_1_1 = "#E8E8E8", val_1_2 = "#73AE80",
  val_2_1 = "#6C83B5", val_2_2 = "#2A5A5B")

}
