% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{plot_epoch_pair}
\alias{plot_epoch_pair}
\title{Plot joint posterior of two gamma parameters}
\usage{
plot_epoch_pair(
  x,
  gamma1 = 1,
  gamma2 = 2,
  xlab = .getLabelGamma.birp(x, gamma1),
  ylab = .getLabelGamma.birp(x, gamma2),
  xlim = range(x$trace_gamma[, c(gamma1, gamma2)]),
  ylim = xlim,
  col = "deeppink",
  diag.col = "black",
  diag.lwd = 1,
  diag.lty = 1,
  zero.col = "black",
  zero.lwd = 1,
  zero.lty = 2,
  print.p = TRUE,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{birp} object.}

\item{gamma1}{Integer; Index of the first gamma parameter to plot on the x-axis. Default is 1.}

\item{gamma2}{Integer; Index of the second gamma parameter to plot on the y-axis. Default is 2.}

\item{xlab}{Character; Label for the x-axis. Default is dynamically set based on \code{gamma1}.}

\item{ylab}{Character; Label for the y-axis. Default is dynamically set based on \code{gamma2}.}

\item{xlim}{Numeric vector of length 2; Optional x-axis limits. Default is the range of gamma1 and gamma2 values.}

\item{ylim}{Numeric vector of length 2; Optional y-axis limits. Default is the same as \code{xlim}.}

\item{col}{Character or color specification; Color for contour lines. Default is \code{"deeppink"}.}

\item{diag.col}{Character or \code{NA}; Color of the diagonal line (\code{y=x}). Use \code{NA} to omit. Default is \code{"black"}.}

\item{diag.lwd}{Numeric; Line width of the diagonal line. Default is 1.}

\item{diag.lty}{Numeric or character; Line type of the diagonal line. Default is 1 (solid).}

\item{zero.col}{Character or \code{NA}; Color of the zero reference lines (at \code{x=0} and \code{y=0}). Use \code{NA} to omit. Default is \code{"black"}.}

\item{zero.lwd}{Numeric; Line width of the zero reference lines. Default is 1.}

\item{zero.lty}{Numeric or character; Line type of the zero reference lines. Default is 2 (dashed).}

\item{print.p}{Logical; If \code{TRUE}, adds an annotation showing the posterior probability \code{P(gamma1 < gamma2 | data)} or \code{P(gamma1 > gamma2 | data)}. Default is \code{TRUE}.}

\item{add}{Logical; If \code{TRUE}, adds the contour plot to an existing plot. Default is \code{FALSE}.}

\item{...}{Additional graphical parameters passed to \code{\link[graphics]{contour}}.}
}
\value{
No return value; called for side effects (plotting).
}
\description{
Plots a 2D density contour for the joint posterior of two gamma parameters from a \code{birp} object.
}
\examples{
data <- simulate_birp(timesOfChange = 2)
est <- birp(data, timesOfChange = 2)
plot_epoch_pair(est)
}
\seealso{
\code{\link{birp}}
}
