% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVA.R
\name{CVA}
\alias{CVA}
\title{Canonical Variate Analysis (CVA) method}
\usage{
CVA(bp, dim.biplot = c(2, 1, 3), e.vects = 1:ncol(bp$X),
           classes=bp$classes, weightedCVA = "weighted", show.class.means = TRUE)
}
\arguments{
\item{bp}{object of class \code{biplot} obtained from preceding function \code{biplot()}.}

\item{dim.biplot}{dimension of the biplot. Only values 1, 2 and 3 are accepted, with default \code{2}.}

\item{e.vects}{which eigenvectors (canonical variates) to extract, with default \code{1:dim.biplot}.}

\item{classes}{vector of the same length as the number of rows in the data matrix
with the class indicator for the samples.}

\item{weightedCVA}{the default is "weighted", specifying a weighted CVA to be performed. Other possible values are "unweightedI" and "unweightedCent".}

\item{show.class.means}{logical, indicating whether to plot the class means on the biplot.}
}
\value{
Object of class CVA with the following elements:
\item{X}{matrix of the centered and scaled numeric variables.}
\item{Xcat}{matrix of the categorical variables.}
\item{raw.X}{original data.}
\item{na.action}{vector of observations that have been removed.}
\item{center}{TRUE or FALSE, whether X is centred.}
\item{scaled}{TRUE or FALSE, whether X is scaled.}
\item{means}{mean of each numerical variable.}
\item{sd}{standard deviation of each numerical variable.}
\item{n}{number of observations.}
\item{p}{number of variables.}
\item{group.aes}{vector of the same length as the number of rows in the data matrix for differentiated aesthetics for samples. }
\item{g.names}{descriptive name to be used for group labels.}
\item{g}{number of groups.}
\item{Title}{title of the biplot to be rendered.}
\item{Z}{matrix with each row containing the details of the point to be plotted (i.e. coordinates).}
\item{Lmat}{matrix for transformation to the canonical space.}
\item{e.vects}{vector indicating which canonical variates are plotted in the biplot.}
\item{ax.one.unit}{one unit in the positive direction of each biplot axis.}
\item{class.means}{logical value, indicating whether the class means should be plotted in the biplot.}
\item{Zmeans}{matrix of the class mean coordinates to be plotted in the biplot.}
}
\description{
This function produces a list of elements to be used for CVA biplot construction.
}
\examples{
biplot(iris[,1:4]) |> CVA(classes=iris[,5])
# create a CVA biplot
biplot(iris[,1:4]) |> CVA(classes=iris[,5]) |> plot()
}
