% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_helpers.R
\name{distance_filter}
\alias{distance_filter}
\title{Helper to filter sets of sites by median distance among all points}
\usage{
distance_filter(site_list, median_distance_filter = "max")
}
\arguments{
\item{site_list}{list of selected sites provided as data.frames. Columns
"Longitude" and "Latitude" are needed for distance calculation.}

\item{median_distance_filter}{(character) optional argument to define a
median distance-based filter based on which sets of sampling sites will be
selected. Default = "max". Options are:"max" and "min".}
}
\value{
A list of sets of selected sites according to \code{median_distance_filter}.
}
\description{
Helper to filter sets of sites by median distance among all points
}
\examples{
# Data
data("m_selection", package = "biosurvey")

slist <- m_selection$selected_sites_random

# Distance filter
max_sites <- distance_filter(slist, median_distance_filter = "max")
}
