% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAM_indices.R
\name{PAM_indices}
\alias{PAM_indices}
\title{Biodiversity indices derived from PAM}
\usage{
PAM_indices(PAM, indices = "all", exclude_column = NULL)
}
\arguments{
\item{PAM}{matrix, data.frame, or base_PAM object containing information on
species presence and absence for a set of sites. Sites are organized in the
rows and species in the columns. See details.}

\item{indices}{(character) code for indices to be calculated. Basic indices
are calculated all the time; other indices need to be specified. Options are:
"all", "basic, "AB", "BW", "BL", "SCSC", "SCSR", "DF", "CC", "WRN", "SRC",
"CMSC", "CMSR", "MCC", and "MRC". Default = "all". See details.}

\item{exclude_column}{(optional) name or numeric index of columns to be
excluded. Default = NULL.}
}
\value{
If \code{PAM} is a matrix or data.frame, the result is a list with the
results described below (depending on \code{indices}). If \code{PAM} is a
base_PAM object, a base_PAM object will be returned and the list described
above will be appended to the element PAM_indices in such an element.
}
\description{
Calculates a set of biodiversity indices using values contained
in a presence-absence matrix.
}
\details{
Descriptions of the codes of all indices to be calculated are presented in
the table below. If \code{indices} = "basic", only basic indices are
calculated. However, basic indices are calculated in all cases not matter the
code(s) defined in \code{indices}. Some indices require previous calculations
of other indices, in such cases, all indices required are added to the final
list. For further details on the way calculations are performed and the
meaning of the indices see Soberón and Cavner (2015)
\doi{https://doi.org/10.17161/bi.v10i0.4801}.\tabular{lrr}{
   Code \tab Index \tab Calculation \cr
   RI \tab Richness \tab Basic \cr
   RA \tab Range \tab Basic \cr
   RIN \tab Richness normalized \tab Basic \cr
   RAN \tab Range normalized \tab Basic \cr
   AB \tab Additive Beta \tab Needs to be defined \cr
   BW \tab Beta Whittaker \tab Needs to be defined \cr
   BL \tab Beta Legendre \tab Needs to be defined and DF \cr
   SCSC \tab Schluter covariance sites-composition \tab Needs to be defined and CMSC \cr
   SCSR \tab Schluter covariance species-ranges \tab Needs to be defined and CMSR \cr
   DF \tab Dispersion field \tab Needs to be defined \cr
   SCC \tab Shared community composition \tab Needs to be defined \cr
   WRN \tab Wright-Reeves nestedness \tab Needs to be defined, BW, and DF \cr
   SRC \tab Stone-Roberts C-score \tab Needs to be defined and DF \cr
   CMSC \tab Covariance matrix sites-composition \tab Needs to be defined, DF, and BW \cr
   CMSR \tab Covariance matrix species-ranges \tab Needs to be defined, SCC, and BW \cr
   MCC \tab Mean composition covariance \tab Calculated with CMSC \cr
   MRC \tab Mean range covariance \tab Calculated with CMSR \cr
}
}
\examples{
# Data
data("sp_data", package = "biosurvey")

# PAM
pam <- PAM_from_table(data = sp_data, ID_column = "ID",
                      species_column = "Species")

pam_ind <- PAM_indices(pam, exclude_column = 1)
pam_ind[1:3]
}
\seealso{
\code{\link{prepare_base_PAM}}
}
