% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getENSEMBL.R
\name{getENSEMBL.gtf}
\alias{getENSEMBL.gtf}
\title{Helper function for retrieving gtf files from ENSEMBL}
\usage{
getENSEMBL.gtf(organism, type = "dna", path, release = NULL)
}
\arguments{
\item{organism}{Organism selector id,
there are three options to characterize an organism:
\itemize{
\item by \code{scientific name}: e.g. \code{organism = "Homo sapiens"}
\item by \code{database specific accession identifier}: e.g. \code{organism = "GCF_000001405.37"} (= NCBI RefSeq identifier for \code{Homo sapiens})
\item by \code{taxonomic identifier from NCBI Taxonomy}: e.g. \code{organism = "9606"} (= taxid of \code{Homo sapiens})
}}

\item{type}{character, biological sequence type (e.g. "dna", "cds")}

\item{path}{location where file shall be stored.}

\item{release}{a numeric, the database release version of ENSEMBL (\code{db = "ensembl"}). Default is \code{release = NULL} meaning
that the most recent database version is used. \code{release = 75} would for human would give the stable
GRCh37 release in ensembl. Value must be > 46, since ensembl did not structure their data
if the standard format before that.}
}
\value{
character filepath to download file, returns FALSE if failed.
}
\description{
This function downloads gff
files of query organisms from ENSEMBL.
}
\author{
Hajk-Georg Drost
}
