% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_comparison.R
\name{compare_secondary_fits}
\alias{compare_secondary_fits}
\title{Model comparison and selection for secondary growth models}
\usage{
compare_secondary_fits(models)
}
\arguments{
\item{models}{a (we recommend named) list of models fitted using \code{\link[=fit_secondary_growth]{fit_secondary_growth()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function is a constructor for \link{SecondaryComparison}
a class that provides several functions for model comparison and model selection
for growth models fitted using \code{\link[=fit_secondary_growth]{fit_secondary_growth()}}. Please see the help pages for
\link{SecondaryComparison} for further details.

Although it is not necessary, we recommend passing the models as a named list,
as these names will later be kept in plots and tables.
}
\examples{

## We first need to fit some models

data("example_cardinal")

sec_model_names <- c(temperature = "Zwietering", pH = "CPM")

known_pars <- list(mu_opt = 1.2, temperature_n = 1,
                   pH_n = 2, pH_xmax = 6.8, pH_xmin = 5.2)
                   
my_start <- list(temperature_xmin = 5, temperature_xopt = 35,
                 pH_xopt = 6.5)
                 
fit1 <- fit_secondary_growth(example_cardinal, my_start, known_pars, sec_model_names)

known_pars <- list(mu_opt = 1.2, temperature_n = 2,
                   pH_n = 2, pH_xmax = 6.8, pH_xmin = 5.2)
                   
 fit2 <- fit_secondary_growth(example_cardinal, my_start, known_pars, sec_model_names)
 
 ## We can now pass the models to the constructor

 comparison <- compare_secondary_fits(list(`n=1` = fit1, 
                                           `n=2` = fit2))
                                           
 ## The function includes several S3 methods for model selection and comparison
 
 print(comparison)
 
 plot(comparison)
 plot(comparison, type = 2)
 
 ## The numerical indexes can be accessed using coef and summary
 
 coef(comparison)
 summary(comparison)

}
