% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynamicGrowth_class.R
\name{DynamicGrowth}
\alias{DynamicGrowth}
\alias{plot.DynamicGrowth}
\title{DynamicGrowth class}
\usage{
\method{plot}{DynamicGrowth}(
  x,
  y = NULL,
  ...,
  add_factor = NULL,
  ylims = NULL,
  label_y1 = "logN",
  label_y2 = add_factor,
  line_col = "black",
  line_size = 1,
  line_type = "solid",
  line_col2 = "black",
  line_size2 = 1,
  line_type2 = "dashed"
)
}
\arguments{
\item{x}{The object of class \code{DynamicGrowth} to plot.}

\item{y}{ignored}

\item{...}{additional arguments passed to \code{plot}.}

\item{add_factor}{whether to plot also one environmental factor.
If \code{NULL} (default), no environmental factor is plotted. If set
to one character string that matches one entry of x$env_conditions,
that condition is plotted in the secondary axis}

\item{ylims}{A two dimensional vector with the limits of the primary y-axis.}

\item{label_y1}{Label of the primary y-axis.}

\item{label_y2}{Label of the secondary y-axis.}

\item{line_col}{Aesthetic parameter to change the colour of the line geom in the plot, see: \code{\link{geom_line}}}

\item{line_size}{Aesthetic parameter to change the thickness of the line geom in the plot, see: \code{\link{geom_line}}}

\item{line_type}{Aesthetic parameter to change the type of the line geom in the plot, takes numbers (1-6) or strings ("solid") see: \code{\link{geom_line}}}

\item{line_col2}{Same as lin_col, but for the environmental factor.}

\item{line_size2}{Same as line_size, but for the environmental factor.}

\item{line_type2}{Same as lin_type, but for the environmental factor.}
}
\description{
The \code{DynamicGrowth} class contains the results of a growth prediction
under dynamic conditions. Its constructor is \code{\link{predict_dynamic_growth}}.

A subclass of list with items:
\itemize{
\item simulation: A tibble with the model prediction
\item gammas: A tibble with the value of each gamma factor for each
value of \code{times}.
\item env_conditions: A list of functions interpolating the environmental
conditions.
\item primary_pars: A list with the model parameters of the primary model.
\item sec_models: A nested list defining the secondary models.
}
}
\section{Functions}{
\itemize{
\item \code{plot.DynamicGrowth}: predicted growth curve under dynamic conditions.
}}

