% Generated by roxygen2 (4.0.2): do not edit by hand
\name{test_features}
\alias{test_features}
\title{Permutation test for feature selection}
\usage{
test_features(target, features, criterion = "ig", quick = TRUE,
  times = 1e+05)
}
\arguments{
\item{target}{target vector.}

\item{features}{\code{integer} matrix of features with number of rows equal
to the length of target vector.}

\item{criterion}{the criterion used in permutation test. See \code{\link{criterions}} for the
list of possible criterions.}

\item{quick}{logical, if \code{TRUE} Quick Permutation Test (QuiPT) is used.}

\item{times}{number of times procedure should be repetead. Ignored if \code{quick} is
\code{TRUE}.}
}
\value{
a vector of objects of htest class that relate to each feature tested
}
\description{
Performs a feature selection on positioned N-gram data using a Fisher's
permutation test.
}
\details{
Currently implemented criterions:
\itemize{
\item{"\code{ig}" - information gain}
}
}
\note{
Both \code{target} and \code{features} must be binary, i.e. contain only 0
and 1 values.
}
\examples{
tar_feat1 <- create_feature_target(10, 390, 0, 600)
tar_feat2 <- create_feature_target(9, 391, 1, 599)
tar_feat3 <- create_feature_target(8, 392, 0, 600)
test_features(tar_feat1[,1], cbind(tar_feat1[,2], tar_feat2[,2],
tar_feat3[,2]))
}
\references{
Radivojac P, Obradovic Z, Dunker AK, Vucetic S,
\emph{Feature selection filters based on the permutation test} in
Machine Learning: ECML 2004, 15th European
Conference on Machine Learning, Springer, 2004.
}
\seealso{
See \code{\link{criterion_distribution}} for insight on QuiPT.
}
\keyword{nonparametric}

