% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_interlab.R
\name{curves_plot}
\alias{curves_plot}
\title{Plot curves}
\usage{
curves_plot(dat, curve, curve_type = "lin_quad", place)
}
\arguments{
\item{dat}{data frame of data values.}

\item{curve}{manual or auto.}

\item{curve_type}{lin or lin_quad.}

\item{place}{UI or save.}
}
\value{
\code{ggplot2} object.
}
\description{
Plot curves
}
\examples{
dat <- data.frame(
  "Lab" = c("A1", "A2"),
  "Module" = c("dicentrics", "dicentrics"),
  "Type" = c("manual", "manual"),
  "radiation quality" = c("Cs-137", "Co-60"),
  "calibration" = c("air kerma", "air kerma"),
  "irradiation" = c("air", "air"),
  "temperature" = c(20, 37),
  "dose rate" = c(0.446, 0.27),
  "curve origin" = c("own", "own"),
  "C" = c(0.001189589, 0.0005),
  "alpha" = c(0.01903783, 0.0142),
  "beta" = c(0.0968831, 0.0759),
  "C std.error" = c(0.0001040828, 0.0005),
  "alpha std.error" = c(0.004119324, 0.0044),
  "beta std.error" = c(0.003505209, 0.0027),
  "max curve dose" = c(6.00, 5.05),
  stringsAsFactors = FALSE,
  check.names = FALSE
)


curves_plot(
  dat = dat,
  curve = "manual",
  curve_type = "lin_quad",
  place = "UI"
)
}
