% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OED_isothermal_limit.R
\name{isothermal_OED_limit}
\alias{isothermal_OED_limit}
\title{OED of isothermal microbial inactivation with detection limit}
\usage{
isothermal_OED_limit(model, pars, limit, n_points, min_time, max_time,
  min_temp, max_temp, criterion = "D", opts = NULL, x_0 = NULL)
}
\arguments{
\item{model}{character string defining the inactivation model to use.}

\item{pars}{list defining the nominal model parameters.}

\item{limit}{numerical value describing the maximum number of log-reductions
that can be identified in the experiment limit = logDL - logN0, where DL
is the detection limit.}

\item{n_points}{numerical stating the number of data points.}

\item{min_time}{numerical stating the lower limit for the time points.}

\item{max_time}{numerical stating the upper limit for the time points.}

\item{min_temp}{numerical stating the lower limit for the temperature.}

\item{max_temp}{numerical stating the upper limit for the temperature.}

\item{criterion}{character string defining the criterion to use.}

\item{opts}{options for the MEIGO algorithm. By default, a maximum of 2000
function evaluations with local finish with the DHC algorithm
(see help from MEIGO).}

\item{x_0}{initial point for the MEIGO algorithm. By default, it is NULL.}
}
\value{
A MEIGO object
}
\description{
Calculates an Optimal Experiment for an isothermal microbial inactivation experiment
considering the maximum duration of the experiment according to the detection limit.
}
\examples{
pars <- list(z = 4.2, D_R = 3.9, temp_ref = 55)
opts <- list(maxeval=2000,local_finish="DHC")
\dontrun{
OED <- isothermal_OED_limit("Bigelow", pars, n_points = 5, criterion = "E-mod", limit = 6,
                      min_time = 0, max_time = 100, min_temp = 52.5, max_temp = 60,
                      opts = opts)
plot(OED)
}

}
