##"io"
sd_section("Input/Output:",
           "Read and Write Common Biomolecular Data Types",
  c(
    "read.pdb",
    "read.fasta",
    "read.fasta.pdb",
    "read.ncdf",        
    "read.dcd",
    "read.crd",
    "read.pqr", 
    "read.mol2",     
    "read.all",
    "read.pdcBD",
    "aln2html",
    "get.pdb",
    "get.seq",
    "load.enmff",
    "write.pdb", 
    "write.crd",
    "write.fasta",
    "write.ncdf",
    "write.pqr",
    "write.pir",
    "mktrj.nma",
    "mktrj.pca",    
    "mktrj.enma",    
    "view.dccm",
    "view.cna"
  )
)

##"sequence"
sd_section("Sequence Analysis:",
           "Do Interesting Things with Protein Sequence",
  c(    
    "consensus",
    "conserv",
    "blast.pdb",
    "hmmer",
    "pfam",
    "uniprot",
    "entropy",
    "ide.filter",
    "seqidentity",
    "motif.find",
    "pdbaln",
    "seq2aln",
    "seqaln",
    "seqaln.pair",
    "seqbind"
    )   
)

##"structure"
sd_section("Structure Analysis:",
           "Do Interesting Things with Protein Structure",
  c(    
    "angle.xyz",
    "blast.pdb",
    "atom.select",
    "combine.sel",
    "cmap",
    "cmap.filter",
    "core.find",
    "com",
    "dccm",
    "filter.dccm",
    "dist.xyz",
    "dm",
    "dssp",
    "dssp.pdbs",
    "geostas",
    "mustang",
    "fit.xyz",
    "binding.site",
    "mktrj",
    "mktrj.pca",
    "overlap",
    "pca",
    "pca.xyz",
    "pca.pdbs",
    "pca.array", 
    "pca.tor",
    "dccm.pca",
    "project.pca",
    "pdbaln",
    "pdb.annotate",
    "pdb2aln",
    "pdb2aln.ind",
    "pdbfit",
    "chain.pdb",
    "convert.pdb",
    "rgyr",
    "rmsd",
    "rmsd.filter",
    "rmsf",
    "rmsip",
    "struct.aln",
    "torsion.pdb",
    "torsion.xyz",
    "wrap.tor",
    "aa2mass",
    "aa.mass",
    "atom.index",
    "atom2mass",
    "atom2ele",
    "cov.nma",
    "dccm.enma",
    "dccm.nma",
    "dccm.xyz",
    "deformation.nma",
    "fluct.nma",
    "inner.prod",
    "load.enmff",
    "mktrj.nma",
    "nma", 
    "nma.pdb",
    "nma.pdbs",
    "normalize.vector",
    "pdbs2pdb",
    "pdbs.filter",
    "plot.enma",
    "plot.nma",
    "plot.rmsip",
    "sdENM",
    "sse.bridges",
    "view.dccm",
    "view.modes",
    "var.xyz",
    "inspect.connectivity"
    )
)


##"trajectory"
sd_section("Trajectory Analysis:",
           "Do Interesting Things with Simulation Data",
  c(    
    "angle.xyz",
    "cmap",
    "cmap.filter",
    "core.find",
    "dccm",
    "dccm.pca",
    "filter.dccm",
    "lmi",
    "dist.xyz",
    "dm",
    "dssp.trj",
    "geostas",
    "fit.xyz",
    "mktrj",
    "mktrj.pca",
    "overlap",
    "project.pca",
    "pca.tor",
    "pca.xyz",
    "pdbaln",
    "rgyr",
    "rmsd",
    "rmsd.filter",
    "rmsf",
    "rmsip",
    "torsion.pdb",
    "torsion.xyz",
    "wrap.tor"
    )
)

##"nma"
sd_section("Normal Mode Analysis:",
           "Probe Large-Scale Protein Motions",
  c(    
    "aa2mass",
    "aa.mass",
    "atom.index",
    "atom2mass",
    "atom2ele",
    "bhattacharyya",
    "cov.nma",
    "covsoverlap",
    "dccm.enma",
    "dccm.nma",
    "dccm.xyz",
    "deformation.nma",
    "geostas",
    "fluct.nma",
    "inner.prod",
    "load.enmff",
    "mktrj",
    "mktrj.nma",
    "mktrj.enma",
    "nma", 
    "nma.pdb",
    "nma.pdbs",
    "normalize.vector",
    "pdbs2pdb",
    "plot.enma",
    "plot.nma",
    "plot.rmsip",
    "sdENM",
    "sse.bridges",
    "sip",
    "var.xyz",
    "view.dccm",
    "view.modes"
    )   
)

##"cna"
 sd_section("Correlation Network Analysis:",
            "Network analysis of dynamic coupling", 
  c(
      "cna",
      "dccm",
      "lmi",
      "filter.dccm",
      "cmap",
      "community.tree",
      "network.amendment",
      "view.cna",
      "view.dccm",
      "plot.cna",
      "print.cna",
      "identify.cna",
      "layout.cna",
      "prune.cna"
   )
 )

##"graphics"
 sd_section("Graphics:",
           "Plotting and Graphic Display",
  c(
    "bwr.colors",
    "vmd.colors",
    "plot.bio3d",
    "plot.blast",
    "plot.core",
    "plot.dccm",
    "plot.dmat",
    "plot.pca",
    "plot.pca.loadings",
    "hclustplot",
    "plot.cna",
    "plot.fasta",
    "plot.hmmer"
    )
)

##"util"
sd_section("Utilities:",
           "Convert and Manipulate Data",
  c(
    "aa.index",
    "aa123",
    "aa2index",
    "aln2html",
    "atom.select",
    "combine.sel",
    "atom2xyz",
    "bio3d-package",
    "bounds",
    "chain.pdb",
    "convert.pdb",
    "diag.ind",
    "difference.vector",
    "gap.inspect",
    "inspect.connectivity",
    "ide.filter",
    "is.gap",
    "is.pdb",
    "is.select",
    "is.xyz",
    "lbio3d",
    "orient.pdb",
    "pairwise",
    "plot.bio3d",
    "print.core",
    "print.cna",
    "print.fasta",
    "print.xyz",
    "rle2",
    "rmsd.filter",
    "pdbseq",
    "seqbind",
    "pdbsplit",
    "store.atom",
    "trim.pdb",
    "unbound",
    "vec2resno",
    "setup.ncore",
    "elements",
    "formula2mass"
    )
)

##"example"
sd_section("Example Data:",
           "Bio3d Example Data",
  c("example.data")
)
#sd_icon("Some title:",
#        "some sub-text",
#        c("pants")
#        )

