% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed-tcrossprodSelf.R
\name{bed_tcrossprodSelf}
\alias{bed_tcrossprodSelf}
\title{tcrossprod / GRM}
\usage{
bed_tcrossprodSelf(
  obj.bed,
  fun.scaling = bed_scaleBinom,
  ind.row = rows_along(obj.bed),
  ind.col = cols_along(obj.bed),
  block.size = block_size(length(ind.row))
)
}
\arguments{
\item{obj.bed}{Object of type \link{bed}, which is the mapping of some bed file.
Use \code{obj.bed <- bed(bedfile)} to get this object.}

\item{fun.scaling}{A function with parameters \code{X} (or \code{obj.bed}), \code{ind.row} and
\code{ind.col}, and that returns a data.frame with \verb{$center} and \verb{$scale} for the
columns corresponding to \code{ind.col}, to scale each of their elements such as followed:
\deqn{\frac{X_{i,j} - center_j}{scale_j}.} Default uses binomial scaling.
You can also provide your own \code{center} and \code{scale} by using \code{\link[bigstatsr:as_scaling_fun]{bigstatsr::as_scaling_fun()}}.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{block.size}{Maximum number of columns read at once.
Default uses \link[bigstatsr]{block_size}.}
}
\value{
A temporary \link[bigstatsr:FBM-class]{FBM}, with the following two attributes:
\itemize{
\item a numeric vector \code{center} of column scaling,
\item a numeric vector \code{scale} of column scaling.
}
}
\description{
Compute \eqn{G G^T} from a bed object, with possible filtering and scaling
of \code{G}. For example, this can be used to compute GRMs.
}
\section{Matrix parallelization}{


Large matrix computations are made block-wise and won't be parallelized
in order to not have to reduce the size of these blocks. Instead, you can use
the \href{https://forum.posit.co/t/intel-mkl-integration-to-r-on-windows/176071}{MKL}
or OpenBLAS in order to accelerate these block matrix computations.
You can control the number of cores used by these optimized matrix libraries
with \code{bigparallelr::set_blas_ncores()}.

}

\examples{
bedfile <- system.file("extdata", "example.bed", package = "bigsnpr")
obj.bed <- bed(bedfile)

K <- bed_tcrossprodSelf(obj.bed)
K[1:4, 1:6] / ncol(obj.bed)

}
