% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hergm.R
\name{hergm}
\alias{hergm}
\title{Hierarchical exponential-family random graph models (HERGMs) with local dependence}
\usage{
hergm(
  object,
  n_clusters,
  n_cores = 1,
  block_membership = NULL,
  estimate_parameters = TRUE,
  verbose = 0,
  n_MM_step_max = 100,
  tol_MM_step = 1e-04,
  initialization_method = 1,
  use_infomap_python = FALSE,
  virtualenv_python = "r-bigergm",
  seed_infomap = NULL,
  weight_for_initialization = 1000,
  seeds = NULL,
  initialized_cluster_data = NULL,
  method_second_step = "MPLE",
  clustering_with_features = TRUE,
  list_multiplied_feature_matrices = NULL,
  fix_covariate_parameter = FALSE,
  compute_pi = FALSE,
  check_alpha_update = FALSE,
  check_block_membership = FALSE,
  cache = NULL,
  ...
)
}
\arguments{
\item{object}{A formula or \code{bigergm} class object. A \code{bigergm} is returned by \code{hergm()}.
When you pass a \code{bigergm} class object to \code{hergm()}, you can restart the MM step.}

\item{n_clusters}{The number of blocks. This must be specified by the user.
When you pass a "bigergm" class object to \code{hergm()}, you don't have to specify this argument.}

\item{n_cores}{The number of CPU cores to use.}

\item{block_membership}{The pre-specified block memberships for each node.
If \code{NULL}, the latent community structure is estimated, assuming that the number of communities is \code{n_clusters}.}

\item{estimate_parameters}{If \code{TRUE}, both clustering and parameter estimation are implemented.
If \code{FALSE}, only clustering is executed.}

\item{verbose}{A logical or an integer: if this is TRUE/1,
the program will print out additional information about the progress of estimation and simulation.
A higher value yields lower level information.}

\item{n_MM_step_max}{The maximum number of MM iterations.
Currently, no early stopping criteria is introduced. Thus \code{n_MM_step_max} MM iterations are exactly implemented.}

\item{tol_MM_step}{Tolerance regarding the relative change of the lower bound of the likelihood
used to decide on the convergence of the clustering step}

\item{initialization_method}{Cluster initialization method.
If \code{1} (the default), \code{igraph}'s infomap is implemented.
If \code{2}, the initial clusters are randomly uniformally selected.
If \code{3}, spectral clustering is conducted.}

\item{use_infomap_python}{If \code{TRUE}, the cluster initialization is implemented using Pythons' infomap.}

\item{virtualenv_python}{Which virtual environment should be used for the infomap algorithm?}

\item{seed_infomap}{seed value (integer) for the infomap algorithm, which can be used to initialize the estimation of the blocks}

\item{weight_for_initialization}{weight value used for cluster initialization. The higher this value, the more weight is put on the initialized alpha.}

\item{seeds}{seed value (integer) for the random number generator}

\item{initialized_cluster_data}{initialized cluster data from which the MM iterations begin.
This can be either a vector of block affiliations of each node or initialized cluster data by Python's infomap (given by .clu format).}

\item{method_second_step}{If "MPLE" (the default), then the maximum pseudolikelihood estimator is implemented when estimating the within-block network model.
If "MLE", then an approximate maximum likelihood estimator is conducted.}

\item{clustering_with_features}{If \code{TRUE}, clustering is implemented using the discrete covariates specified in the formula.}

\item{list_multiplied_feature_matrices}{a list of multiplied feature adjacency matrices necessary for MM step.
If \code{NULL}, \code{hergm()} automatically calculates. Or you can calculate by \code{compute_multiplied_feature_matrices()}.}

\item{fix_covariate_parameter}{If \code{TRUE}, when estimating the within-block network model,
parameters for covariates are fixed at the estimated of the between-block network model.}

\item{compute_pi}{If \code{TRUE}, this function keeps track of pi matrices at each MM iteration.
If the network is large, we strongly recommend to set to be \code{FALSE}.}

\item{check_alpha_update}{If \code{TRUE}, this function keeps track of alpha matrices at each MM iteration.
If the network is large, we strongly recommend to set to be \code{FALSE}.}

\item{check_block_membership}{If TRUE, this function keeps track of estimated block memberships at each MM iteration.}

\item{cache}{a \code{cachem} cache object used to store intermediate calculations such as eigenvector decomposition results.}

\item{...}{Additional arguments, to be passed to lower-level functions}
}
\value{
An object of class 'bigergm' including the results of the fitted model.
These include:
\describe{
\item{call:}{call of the mode}
\item{partition:}{vector of the found partition of the nodes into cluster}
\item{initial_block:}{vector of the initial partition of the nodes into cluster}
\item{sbm_pi:}{Connection probabilities represented as a \code{n_clusters x n_clusters} matrix from the first stage of the estimation between all clusters}
\item{MM_list_z:}{list of cluster allocation for each node and each iteration}
\item{MM_list_alpha:}{list of posterior distributions of cluster allocations for all nodes for each iteration}
\item{MM_change_in_alpha:}{change in 'alpha' for each iteration}
\item{MM_lower_bound:}{ vector of the evidence lower bounds from the MM algorithm}
\item{alpha: }{matrix representing the converged posterior distributions of cluster allocations for all nodes}
\item{counter_e_step:}{ integer number indicating the number of iterations carried out}
\item{adjacency_matrix:}{sparse matrix representing the adjacency matrix used for the estimation}
\item{estimation_status:}{character stating the status of the estimation}
\item{est_within:}{\code{\link[ergm]{ergm}} object of the model for within cluster connections }
\item{est_between:}{\code{\link[ergm]{ergm}} object of the model for between cluster connections}
\item{checkpoint:}{list of information to continue the estimation}
\item{membership_before_kmeans:}{vector of the found partition of the nodes into cluster before the final check for bad clusters}
\item{estimate_parameters:}{binary value if the parameters in the second step of the algorithm should be estimated or not}
}
}
\description{
The function hergm estimates and simulates three classes of hierarchical exponential-family random graph models.
}
\examples{
# Load an embedded network object.
data(toyNet)

# Specify the model that you would like to estimate.
model_formula <- toyNet ~ edges + nodematch("x") + nodematch("y") + triangle
# Estimate the model
hergm_res <- bigergm::hergm(
  object = model_formula,
  # The model you would like to estimate
  n_clusters = 4,
  # The number of blocks
  n_MM_step_max = 10,
  # The maximum number of MM algorithm steps
  estimate_parameters = TRUE,
  # Perform parameter estimation after the block recovery step
  clustering_with_features = TRUE,
  # Indicate that clustering must take into account nodematch on characteristics
  check_block_membership = FALSE)
  
}
