% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thematicEvolution.R
\name{thematicEvolution}
\alias{thematicEvolution}
\title{Perform a Thematic Evolution Analysis}
\usage{
thematicEvolution(M, field = "ID", years, n = 250, minFreq = 2,
  size = 0.5, stemming = FALSE, repel = TRUE)
}
\arguments{
\item{M}{is a bibliographic data frame obtained by the converting function \code{\link{convert2df}}.}

\item{field}{is a character object. It indicates the content field to use. Field can be one of c=("ID","DE","TI","AB"). Default value is \code{field="ID"}.}

\item{years}{is a numeric vector of two or more unique cut points.}

\item{n}{is numerical. It indicates the number of words to use in the network analysis}

\item{minFreq}{is numerical. It indicates the min frequency of words included in to a cluster.}

\item{size}{is numerical. It indicates del size of the cluster circles and is a numebr in the range (0.01,1).}

\item{stemming}{is logical. If it is TRUE the word (from titles or abtracts) will be stemmed (using the Porter's algorithm).}

\item{repel}{is logical. If it is TRUE ggplot uses geom_label_repel instead of geom_label.}
}
\value{
a list containing:
\tabular{lll}{
\code{nets}\tab   \tab The thematic nexus graph for each comparison\cr
\code{incMatrix}\tab   \tab Some useful statistics about the thematic nexus}
}
\description{
It performs a Thematic Evolution Analysis based on co-word network analysis and clustering.
The methodology is inspired by the proposal of Cobo et al. (2011).
}
\details{
\code{\link{thematicEvolution}} starts from two or more thematic maps created by \code{\link{thematicMap}} function.
}
\examples{

data(scientometrics)
years=c(2000)

nexus <- thematicEvolution(scientometrics,field="ID", years=years, n=100,minFreq=2)

}
\seealso{
\code{\link{thematicMap}} function to create a thematic map based on co-word network analysis and clustering.

\code{\link{cocMatrix}} to compute a bibliographic bipartite network.

\code{\link{networkPlot}} to plot a bibliographic network.
}
