% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citations.R
\name{citations}
\alias{citations}
\title{Citation frequency distribution}
\usage{
citations(M, field = "article", sep = ";")
}
\arguments{
\item{M}{is a bibliographic data frame obtained by the converting function \code{\link{convert2df}}.
It is a data matrix with cases corresponding to manuscripts and variables to Field Tag in the original SCOPUS and Thomson Reuters' ISI Web of Knowledge file.}

\item{field}{is a character. It can be "article" or "author" to obtain frequency distribution of cited citations or cited first authors respectively. The default is \code{field = "article"}.}

\item{sep}{is the field separator character. This character separates citations in each string of CR column of the bibiographic data frame. The default is \code{sep = ";"}.}
}
\value{
an object of \code{class} "table".
}
\description{
It calculates frequency distribution of citations.
}
\examples{
## EXAMPLE 1: Cited articles

data(scientometrics)

CR <- citations(scientometrics, field = "article", sep = ";")

CR[1:10]

## EXAMPLE 2: Cited first authors

data(scientometrics)

CR <- citations(scientometrics, field = "author", sep = ";")

CR[1:10]

}
\seealso{
\code{\link{biblioAnalysis}} function for bibliometric analysis.

\code{\link{summary}} to obtain a summary of the results.

\code{\link{plot}} to draw some useful plots of the results.
}

