% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OCFunctions.R
\name{getGoDecisions}
\alias{getGoDecisions}
\title{getGoDecisions}
\usage{
getGoDecisions(
  analyses_list,
  cohort_names,
  evidence_levels,
  boundary_rules,
  overall_min_gos = 1
)
}
\arguments{
\item{analyses_list}{An object of class \code{analysis_list},
as created with \code{\link[bhmbasket]{performAnalyses}}}

\item{cohort_names}{A vector of strings with the names of the cohorts, e.g.
\code{c('p_1', 'p_2')}}

\item{evidence_levels}{A vector of numerics in \code{(0, 1)} for the
posterior probability thresholds for the cohorts.
Will be recycled to match the number of methods in the \code{analyses_list}}

\item{boundary_rules}{A quote of a vector for the boundary rules,
\code{quote(c(...))}, see details.
The number of decisions to be taken must match the number of cohorts.
Will be recycled to match the number of methods in the \code{analyses_list}}

\item{overall_min_gos}{A positive integer for the minimum number of
cohort-wise go decisions required for an overall go decision
 Default: \code{1}}
}
\value{
An object of class \code{decision_list}
}
\description{
This function applies decision rules to the analyzed trials.
The resulting \code{decision_list} can be further processed with
\code{\link[bhmbasket]{getGoProbabilities}} or
\code{\link[bhmbasket]{continueRecruitment}}.
}
\details{
This function applies decision rules of the following type to the
outcomes of (simulated) basket trials with binary endpoints:
\deqn{P(p_j|data > p_{B,j}) > \gamma,}
where \eqn{p_j|data} is the posterior response rate of cohort \eqn{j},
\eqn{p_{B,j}} is the response rate boundary of cohort \eqn{j},
and \eqn{\gamma} is the evidence level.
This rule can equivalently be written as \deqn{q_{1-\gamma,j} > p_{B,j},}
where \eqn{q_{1-\gamma,j}} is the \eqn{1-\gamma}-quantile of the posterior
response rate of cohort \eqn{j}.

The arguments \code{cohort_names} and \code{evidence_levels} determine
\eqn{q_{1-\gamma,j}}, where the entries of \code{cohort_names} and
\code{evidence_levels} are matched corresponding to their order.

The argument \code{boundary_rules} provides the rules that describe what
should happen with  the posterior quantiles \eqn{q_{1-\gamma,j}}.
The first posterior quantile determined by the first items of
\code{cohort_names} and \code{evidence_levels} is referred to as \code{x[1]},
the second as \code{x[2]}, etc.
Using the \code{quote(c(...))}-notation,
many different rules can be implemented.
A decision rule for only one cohort would be
\code{boundary_rules = quote(c(x[1] > 0.1))},
\code{cohort_names = 'p_1'}, and \code{evidence_levels = 0.5},
which implements the rule \eqn{P(p_1|data > 0.1) > 0.5}.
The number of decisions to be taken must match the number of cohorts, i.e.
for each cohort there must be a decision rule in the vector separated by a comma.
See the example section for a decision rule for more than one cohort and
the example of \code{\link[bhmbasket]{negateGoDecisions}}
for the implementation of a more complex decision rule.
}
\examples{
scenarios_list <- simulateScenarios(
  n_subjects_list     = list(c(10, 20, 30)),
  response_rates_list = list(c(0.1, 0.1, 0.9)),
  n_trials            = 10)

analyses_list <- performAnalyses(
  scenario_list      = scenarios_list,
  target_rates       = rep(0.5, 3),
  n_mcmc_iterations  = 100,
  n_cores            = 1L)

## Decision rule for more than one cohort
decisions_list <- getGoDecisions(
  analyses_list   = analyses_list,
  cohort_names    = c("p_1", "p_2", "p_3"),
  evidence_levels = c(0.5, 0.5, 0.8),
  boundary_rules  = quote(c(x[1] > 0.7, x[2] < 0.3, x[3] < 0.6)))

## Decision rule for only two of the three cohorts
decisions_list <- getGoDecisions(
  analyses_list   = analyses_list,
  cohort_names    = c("p_1", "p_3"),
  evidence_levels = c(0.5, 0.8),
  boundary_rules  = quote(c(x[1] > 0.7, TRUE, x[3] < 0.6)),
  overall_min_gos = 2L)

## Different decision rules for each method
## This works the same way for the different evidence_levels
decisions_list <- getGoDecisions(
  analyses_list   = analyses_list,
  cohort_names    = c("p_1", "p_2", "p_3"),
  evidence_levels = c(0.5, 0.5, 0.8),
  boundary_rules  = list(quote(c(x[1] > 0.1, x[2] < 0.5, x[3] < 0.1)),  # "berry"
                         quote(c(x[1] > 0.2, x[2] < 0.4, x[3] < 0.2)),  # "exnex"
                         quote(c(x[1] > 0.3, x[2] < 0.3, x[3] < 0.3)),  # "exnex_adj"
                         quote(c(x[1] > 0.4, x[2] < 0.2, x[3] < 0.4)),  # "pooled"
                         quote(c(x[1] > 0.5, x[2] < 0.1, x[3] < 0.5)))) # "stratified"
}
\seealso{
\code{\link[bhmbasket]{performAnalyses}}
 \code{\link[bhmbasket]{getGoProbabilities}}
 \code{\link[bhmbasket]{negateGoDecisions}}
 \code{\link[bhmbasket]{continueRecruitment}}
}
\author{
Stephan Wojciekowski
}
