% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggum_simulation.R
\name{ggum_simulation}
\alias{ggum_simulation}
\title{GGUM Simulation}
\usage{
ggum_simulation(n, m, K, theta = NULL, alpha = NULL, delta = NULL,
  tau = NULL, theta_params = c(0, 1), alpha_params = c(1.5, 1.5,
  0.25, 4), delta_params = c(2, 2, -5, 5), tau_params = c(1.5, 1.5, -2,
  0))
}
\arguments{
\item{n}{An integer vector of length one giving the number of respondents}

\item{m}{An integer vector of length one giving the number of items}

\item{K}{An integer vector giving the number of options for each item;
if the vector is of length one, all m items will have the same number of
options.}

\item{theta}{(Optional) A numeric vector of respondents' latent traits;
if not given, the values are drawn from a normal distribution whose
mean and standard deviation are given by the \code{theta_params} parameter}

\item{alpha}{(Optional) A numeric vector of items' discrimination parameters;
if not given, the values are drawn from a four parameter beta distribution
whose parameters are given by \code{alpha_params}}

\item{delta}{(Optional) A numeric vector of items' location parameters;
if not given, the values are drawn from a four parameter beta distribution
whose parameters are given by \code{delta_params}}

\item{tau}{(Optional) A list of numeric vectors giving each item's option
thresholds; if not given, the values are drawn from a four parameter beta
distribution whose parameters are given by \code{tau_params}}

\item{theta_params}{A numeric vector of length two; the mean and standard
deviation of the normal distribution theta is drawn from}

\item{alpha_params}{A numeric vector of length four; the two shape
parameters and a and b values for the four parameter beta distribution
alpha is drawn from; the default is 1.5, 1.5, 0.25, and 4}

\item{delta_params}{A numeric vector of length four; the two shape
parameters and a and b values for the four parameter beta distribution
delta is drawn from; the default is 2, 2, -5, and 5}

\item{tau_params}{A numeric vector of length four;the two shape
parameters and a and b values for the four parameter beta distribution
each tau vector is drawn from; the default is 1.5, 1.5, -2, and 0}
}
\value{
A list with five elements; "theta" containing the theta draws,
  "alpha" containing the alpha draws, "delta" containing the delta draws,
  "tau" containing the tau draws, and "response_matrix" containing the
  simulated response matrix.
}
\description{
Generates randomly drawn item and person parameters, and simulated responses.
}
\examples{
## Simulate data with 10 items, each with four options, and 100 respondents
set.seed(123)
sim_data <- ggum_simulation(100, 10, 4)
str(sim_data)

}
\seealso{
\code{\link{ggumProbability}}
}
