% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmbf01.R
\name{nmbf01}
\alias{nmbf01}
\title{Normal moment prior Bayes factor}
\usage{
nmbf01(estimate, se, null = 0, psd, log = FALSE)
}
\arguments{
\item{estimate}{Parameter estimate}

\item{se}{Standard error of the parameter estimate}

\item{null}{Parameter value under the point null hypothesis. Defaults to
\code{0}}

\item{psd}{Spread of the normal moment prior assigned to the parameter under
the alternative. The modes of the prior are located at
\eqn{\pm\sqrt{2}\,\code{psd}}{+-sqrt(2)*\code{psd}}}

\item{log}{Logical indicating whether the natural logarithm of the Bayes
factor should be returned. Defaults to \code{FALSE}}
}
\value{
Bayes factor in favor of the null hypothesis over the alternative (BF
    > 1 indicates evidence for the null hypothesis, whereas BF < 1 indicates
    evidence for the alternative)
}
\description{
This function computes the Bayes factor that quantifies the
    evidence that the data (in the form of an asymptotically normally
    distributed parameter estimate with standard error) provide for a point
    null hypothesis with a normal moment prior assigned to the parameter
    under the alternative.
}
\details{
A normal moment prior has density \eqn{f(x \mid \code{null},
    \code{psd}) = N(x \mid \code{null}, \code{psd}^2) \times (x -
    \code{null})/ \code{psd}^2}{f(x|\code{null},\code{psd}) =
    N(x|\code{null},\code{psd})*(x - \code{null})^2/\code{psd}^2} with
    \eqn{N(x \mid m, v)}{N(x|m,v)} the normal density with mean \eqn{m} and
    variance \eqn{v} evaluated at \eqn{x}.
}
\examples{
nmbf01(estimate = 0.25, se = 0.05, null = 0, psd = 0.5/sqrt(2)) # mode at 0.5

}
\references{
Johnson, V. E. and Rossell, D. (2010). On the use of non-local
    prior densities in Bayesian hypothesis tests. Journal of the Royal
    Statistical Society: Series B (Statistical Methodology), 72(2):143–170.
    \doi{10.1111/j.1467-9868.2009.00730.x}

Pramanik, S. and Johnson, V. E. (2024). Efficient alternatives for Bayesian
    hypothesis tests in psychology. Psychological Methods, 29(2):243–261.
    \doi{10.1037/met0000482}
}
\seealso{
\link{nmbf01}, \link{pnmbf01}, \link{nnmbf01}, \link{powernmbf01}
}
\author{
Samuel Pawel
}
