% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuisance_models.R
\name{nuisanceModel_mean}
\alias{nuisanceModel_mean}
\title{Normal mean model, with nuisance time series}
\usage{
nuisanceModel_mean(mu.mu0 = 0, mu.sd = 10000, prop.scaling = 1)
}
\arguments{
\item{mu.mu0, mu.sd}{A priori mean and standard deviation of mu}

\item{prop.scaling}{Scaling parameter for generating Metropolis-Hastings
proposals of parameter of interest theta=mu}
}
\value{
S3 \code{nuisanceModel} object representing the model parameter theta=mu
of interest, containing the following fields:
  \item{theta_dim}{Dimension of parameter of interest (here: \code{theta_dim=1})}
  \item{excludeBoundary}{Logical; Should the outermost Fourier frequencies be 
  ignored in the frequency domain representation? (here: \code{excludeBoundary=F})}
  \item{get_noise}{Function taking the two arguments \code{data,theta} 
  to compute the nuisance/noise time series e_t from data and parameter 
  theta of interest. (here: e_t=data-theta)}
  \item{propose_next_theta}{Function taking the parameters \code{data} 
  (Numeric vector of input data), \code{f} (Numeric Vector of current 
  spectral density at the Fourier frequencies within the Gibbs sampling algorithm) 
  and \code{previous_theta} (Previously sampled value of mu) and 
  returning a new proposal value for mu}
  \item{initialize_theta}{Function taking the Numeric Vector \code{data} of input
  data as argument to generate an initial value for mu to start an MCMC
  algorithm (here: \code{mean(data)})}
  \item{lprior_theta}{Function; Log density of prior of mu (here: log density of N(mu.mu0,mu.sd^2))}
}
\description{
This class represents the mean model X_t=mu+e_t
with mu~N(mu.mu0,mu.sd^2) and e_t being a nuisance parameter time series
}
\details{
The returned object of this function is intended for usage within
\link[beyondWhittle]{gibbs_AR_nuisance}, \link[beyondWhittle]{gibbs_NP_nuisance}
and \link[beyondWhittle]{gibbs_NPC_nuisance}.
The method \code{propose_next_theta} is optimized to be close to the
marginal posterior of mu in the model.
The proposal scaling can be controlled with the parameter \code{prop.scaling},
where larger values yield a broader (smaller values yield narrower) 
proposal distribution.
}
\keyword{internal}
