% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tipdate_taxa_to_xml_trait.R
\name{tipdate_taxa_to_xml_trait}
\alias{tipdate_taxa_to_xml_trait}
\title{Internal function}
\usage{
tipdate_taxa_to_xml_trait(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
lines of XML text
}
\description{
Internal function to creates the '\code{trait}' section
of a BEAST2 XML parameter file,
which is part of a '\code{tree}' section,
without being indented.
}
\details{
The \code{tree} tag has these elements:
\preformatted{
<run[...]>
  <state[...]>
    <tree[...]>
      <trait[...]>
      This part
      </trait>
    </tree>
  </run>
</state>
}
}
\author{
Richèl J.C. Bilderbeek
}
