% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_lines.R
\name{compare_lines}
\alias{compare_lines}
\title{Internal function}
\usage{
compare_lines(
  lines,
  expected,
  section = NA,
  created_lines_filename = get_beautier_tempfilename(pattern = "created", fileext =
    ".xml"),
  expected_lines_filename = get_beautier_tempfilename(pattern = "expected", fileext =
    ".xml")
)
}
\arguments{
\item{lines}{the created lines}

\item{expected}{the expected/goal/target lines}

\item{section}{the XML section. Leave at NA to compare all lines}

\item{created_lines_filename}{name of the file where the (section of
the) created lines are stored}

\item{expected_lines_filename}{name of the file where the (section of
the) expected lines are stored}
}
\value{
nothing. Instead, two files are created, with the
  names \code{created_lines_filename}
  and \code{expected_lines_filename} that contain the
  section under investigation, so that a diff tool
  can compare these
}
\description{
Internal debug function to compare the actually created
lines to expected lines using any diff tool
}
\examples{
check_empty_beautier_folder()

# Creates temporary files in beautier folder
compare_lines(
  lines = readLines(get_beautier_path("bd_2_4.xml")),
  expected = readLines(get_beautier_path("bd_2_4.xml"))
)

remove_beautier_folder()
check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
