% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_mcmc.R
\name{check_mcmc}
\alias{check_mcmc}
\title{Check if the MCMC is a valid MCMC object.}
\usage{
check_mcmc(mcmc)
}
\arguments{
\item{mcmc}{one MCMC.
Use \code{\link{create_mcmc}} to create an MCMC.
Use \code{\link{create_ns_mcmc}} to create an MCMC
  for a Nested Sampling run.
Use \code{\link{check_mcmc}} to check if an MCMC is valid.
Use \code{\link{rename_mcmc_filenames}} to rename the filenames in an MCMC.}
}
\value{
nothing
}
\description{
Calls \code{stop} if the MCMC is invalid
}
\examples{
library(testthat)

expect_silent(check_mcmc(create_mcmc()))

 # Must stop on non-MCMCs
expect_error(check_mcmc(mcmc = "nonsense"))
expect_error(check_mcmc(mcmc = NULL))
expect_error(check_mcmc(mcmc = NA))
}
\seealso{
Use \code{\link{create_mcmc}} to create a valid MCMC
}
\author{
Richèl J.C. Bilderbeek
}
