% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_rate_at_param}
\alias{create_rate_at_param}
\alias{create_param_rate_at}
\title{Create a parameter called 'rate AT'}
\usage{
create_rate_at_param(id = NA, estimate = TRUE, value = "1.0",
  lower = "0.0")
}
\arguments{
\item{id}{the parameter's ID}

\item{estimate}{TRUE if this parameter is to be estimated by BEAST2,
FALSE otherwise}

\item{value}{value of the parameter}

\item{lower}{lowest possible value of the parameter. If the parameter
is estimated, \code{lower} must be less than \code{value}}
}
\value{
a parameter called 'rate AT'
}
\description{
Create a parameter called 'rate AT'
}
\examples{
  # Create parameter
  rate_at_param <- create_rate_at_param(value = 1, estimate = FALSE)

  # Use the parameter to create a BEAST2 input file
  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    site_model = create_gtr_site_model(
      rate_at_param = rate_at_param
    )
  )
  testit::assert(file.exists(beast2_input_file))
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richèl J.C. Bilderbeek
}
