% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mcmc.R
\name{create_mcmc}
\alias{create_mcmc}
\title{Create an MCMC configuration.}
\usage{
create_mcmc(chain_length = 1e+07, store_every = -1)
}
\arguments{
\item{chain_length}{length of the MCMC chain}

\item{store_every}{number of states the MCMC will process
before the posterior's state will be saved to file.
Use -1 or \code{NA} to use the default frequency.}
}
\value{
an MCMC configuration
}
\description{
Create an MCMC configuration, as in the BEAUti MCMC tab.
The number of states that will be saved equals the chain
length (\code{chain_length}) divided by the number of
states between each sampling event (\code{store_every})
}
\examples{
  # Create an MCMC chain with 50 states
  mcmc <- create_mcmc(chain_length = 50000, store_every = 1000)

  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    get_fasta_filename(),
    beast2_input_file,
    mcmc = mcmc
  )
  testit::assert(file.exists(beast2_input_file))
}
\seealso{
\itemize{
    \item \link{are_equal_mcmcs} to check if two MCMCs are equal
  }
}
\author{
Richèl J.C. Bilderbeek
}
