% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mcmc.R
\name{create_mcmc}
\alias{create_mcmc}
\title{Function to create the MCMC options, as in the BEAUti MCMC tab.}
\usage{
create_mcmc(chain_length = 1e+07, store_every = -1)
}
\arguments{
\item{chain_length}{the MCMC's chain length}

\item{store_every}{number of states the posterior will be saved to file.
Use -1 or NA to use the default frequency}
}
\value{
an mcmc
}
\description{
Function to create the MCMC options, as in the BEAUti MCMC tab.
}
\examples{
  mcmc <- create_mcmc(chain_length = 50000)

  create_beast2_input_file(
    get_fasta_filename(),
    "create_mcmc.xml",
    mcmc = mcmc
  )
  testit::assert(file.exists("create_mcmc.xml"))
}
\author{
Richel J.C. Bilderbeek
}
