% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_exp_distr}
\alias{create_exp_distr}
\alias{create_distr_exp}
\title{Create an exponential distribution}
\usage{
create_exp_distr(id = NA, mean = create_mean_param(value = 1))
}
\arguments{
\item{id}{the distribution's ID}

\item{mean}{the mean parameter,
as returned by \code{\link{create_mean_param}}}
}
\value{
an exponential distribution
}
\description{
Create an exponential distribution
}
\examples{
  exp_distr <- create_exp_distr()

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "my_beast.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = exp_distr
    )
  )
  testit::assert(file.exists("my_beast.xml"))
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richel J.C. Bilderbeek
}
