% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree_prior.R
\name{create_cbs_tree_prior}
\alias{create_cbs_tree_prior}
\alias{create_tree_prior_cbs}
\title{Create a Coalescent Bayesian Skyline tree prior}
\usage{
create_cbs_tree_prior(id = NA, group_sizes_dimension = 5)
}
\arguments{
\item{id}{an alignment's IDs.
An ID can be extracted from its FASTA filesname
with \code{\link{get_ids}})}

\item{group_sizes_dimension}{the group sizes' dimension, as used
by the CBS tree prior (see \code{\link{create_cbs_tree_prior}})}
}
\value{
a Coalescent Bayesian Skyline tree_prior
}
\description{
Create a Coalescent Bayesian Skyline tree prior
}
\examples{
  cbs_tree_prior <- create_cbs_tree_prior()

  create_beast2_input_file(
    input_filenames = get_beautier_path("test_output_6.fas"),
    "create_cbs_tree_prior.xml",
    tree_priors = cbs_tree_prior
  )
  testit::assert(file.exists("create_cbs_tree_prior.xml"))
}
\seealso{
An alignment ID can be extracted from
  its FASTA filesname using \code{\link{get_id}}
}
\author{
Richel J.C. Bilderbeek
}
