% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_options.R
\name{create_beast2_options}
\alias{create_beast2_options}
\title{Function to create a set of BEAST2 options.}
\usage{
create_beast2_options(
  input_filename = create_temp_input_filename(),
  output_state_filename = create_temp_state_filename(),
  rng_seed = NA,
  n_threads = NA,
  use_beagle = FALSE,
  overwrite = TRUE,
  beast2_path = get_default_beast2_path(),
  verbose = FALSE
)
}
\arguments{
\item{input_filename}{the name of a BEAST2 input XML file.
This file usually has an \code{.xml} extension.
Use \link{create_temp_input_filename} to create a temporary
filename with that extension.}

\item{output_state_filename}{name of the \code{.xml.state} file to create.
Use \link{create_temp_state_filename} to create a temporary
filename with that extension.}

\item{rng_seed}{the random number generator seed of the BEAST2 run.
Must be a non-zero positive integer value or \link{NA}.
If \code{rng_seed} is \link{NA}, BEAST2 will pick a random seed}

\item{n_threads}{the number of computational threads to use.
Use \link{NA} to use the BEAST2 default of 1.}

\item{use_beagle}{use BEAGLE if present}

\item{overwrite}{if TRUE: overwrite the \code{.log}
and \code{.trees} files if one of these exists.
If FALSE, BEAST2 will not be started if
\itemize{
  \item{the \code{.log} file exists}
  \item{the \code{.trees} files exist}
  \item{the \code{.log} file created by BEAST2 exists}
  \item{the \code{.trees} files created by BEAST2 exist}
}}

\item{beast2_path}{name of either a BEAST2 binary file
(usually simply \code{beast})
or a BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}

\item{verbose}{if TRUE, additional information is displayed, that
is potentially useful in debugging}
}
\value{
a BEAST2 options structure,
which is a \link{list} of all function arguments,
of which all elements are checked (by \link{check_beast2_options})
}
\description{
These BEAST2 options are the R equivalent of the command-line options.
}
\examples{
check_empty_beaustier_folders()

beast2_options <- create_beast2_options()
check_beast2_options(beast2_options)

check_empty_beaustier_folders()
}
\author{
Richèl J.C. Bilderbeek
}
