% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorSms.R
\name{ExtractorSms}
\alias{ExtractorSms}
\title{Class to handle SMS files with tsms extension}
\description{
This class that inherits from the \code{\link{Instance}} class and
implements the functions of extracting the text and the date of an tsms type file.
}
\section{Details}{

Due to the fact that the creation date of the message can not be
extracted from the text of an SMS, the date will be initialized to empty.
}

\section{Inherit}{

This class inherits from \code{\link{Instance}} and implements the
\code{obtainSource} and \code{obtainDate} abstracts functions.
}

\seealso{
\code{\link{ExtractorEml}}, \code{\link{ExtractorTwtid}},
\code{\link{ExtractorYtbid}}, \code{\link{Instance}}
}
\section{Super class}{
\code{\link[bdpar:Instance]{bdpar::Instance}} -> \code{ExtractorSms}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ExtractorSms$new()}}
\item \href{#method-obtainDate}{\code{ExtractorSms$obtainDate()}}
\item \href{#method-obtainSource}{\code{ExtractorSms$obtainSource()}}
\item \href{#method-toString}{\code{ExtractorSms$toString()}}
\item \href{#method-clone}{\code{ExtractorSms$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addBanPipes">}\href{../../bdpar/html/Instance.html#method-addBanPipes}{\code{bdpar::Instance$addBanPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addFlowPipes">}\href{../../bdpar/html/Instance.html#method-addFlowPipes}{\code{bdpar::Instance$addFlowPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addProperties">}\href{../../bdpar/html/Instance.html#method-addProperties}{\code{bdpar::Instance$addProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="checkCompatibility">}\href{../../bdpar/html/Instance.html#method-checkCompatibility}{\code{bdpar::Instance$checkCompatibility()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getBanPipes">}\href{../../bdpar/html/Instance.html#method-getBanPipes}{\code{bdpar::Instance$getBanPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getData">}\href{../../bdpar/html/Instance.html#method-getData}{\code{bdpar::Instance$getData()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getDate">}\href{../../bdpar/html/Instance.html#method-getDate}{\code{bdpar::Instance$getDate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getFlowPipes">}\href{../../bdpar/html/Instance.html#method-getFlowPipes}{\code{bdpar::Instance$getFlowPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getNamesOfProperties">}\href{../../bdpar/html/Instance.html#method-getNamesOfProperties}{\code{bdpar::Instance$getNamesOfProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getPath">}\href{../../bdpar/html/Instance.html#method-getPath}{\code{bdpar::Instance$getPath()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getProperties">}\href{../../bdpar/html/Instance.html#method-getProperties}{\code{bdpar::Instance$getProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSource">}\href{../../bdpar/html/Instance.html#method-getSource}{\code{bdpar::Instance$getSource()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSpecificProperty">}\href{../../bdpar/html/Instance.html#method-getSpecificProperty}{\code{bdpar::Instance$getSpecificProperty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="invalidate">}\href{../../bdpar/html/Instance.html#method-invalidate}{\code{bdpar::Instance$invalidate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isInstanceValid">}\href{../../bdpar/html/Instance.html#method-isInstanceValid}{\code{bdpar::Instance$isInstanceValid()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isSpecificProperty">}\href{../../bdpar/html/Instance.html#method-isSpecificProperty}{\code{bdpar::Instance$isSpecificProperty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setData">}\href{../../bdpar/html/Instance.html#method-setData}{\code{bdpar::Instance$setData()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setDate">}\href{../../bdpar/html/Instance.html#method-setDate}{\code{bdpar::Instance$setDate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setProperties">}\href{../../bdpar/html/Instance.html#method-setProperties}{\code{bdpar::Instance$setProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSource">}\href{../../bdpar/html/Instance.html#method-setSource}{\code{bdpar::Instance$setSource()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSpecificProperty">}\href{../../bdpar/html/Instance.html#method-setSpecificProperty}{\code{bdpar::Instance$setSpecificProperty()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ExtractorSms}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorSms$new(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. Path of the tsms file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obtainDate"></a>}}
\if{latex}{\out{\hypertarget{method-obtainDate}{}}}
\subsection{Method \code{obtainDate()}}{
Obtains the date of the SMS file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorSms$obtainDate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obtainSource"></a>}}
\if{latex}{\out{\hypertarget{method-obtainSource}{}}}
\subsection{Method \code{obtainSource()}}{
Obtains the source of the SMS file. Reads the file indicated
in the path. In addition, it initializes the data field with the initial
source.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorSms$obtainSource()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-toString"></a>}}
\if{latex}{\out{\hypertarget{method-toString}{}}}
\subsection{Method \code{toString()}}{
Returns a \code{\link{character}} representing the instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorSms$toString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link{Instance}} \code{\link{character}} representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorSms$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
