% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToLowerCasePipe.R
\docType{class}
\name{ToLowerCasePipe}
\alias{ToLowerCasePipe}
\title{Class to convert the data field of an Instance to lower case}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
ToLowerCasePipe
}
\description{
Class to convert the data field of an \code{\link{Instance}}
to lower case.
}
\section{Constructor}{

\preformatted{
ToLowerCasePipe$new(propertyName = "",
                    alwaysBeforeDeps = list(),
                    notAfterDeps = list())
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
}
}
}
}

\section{Inherit}{

This class inherits from \code{\link{PipeGeneric}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to convert the data to lower case.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}

\item{\bold{toLowerCase:}}{
converts the data to lower case.
\itemize{
\item{\emph{Usage:}}{
\code{toLowerCase(data)}
}
\item{\emph{Value:}}{
data in lower case.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text to preproccess.
}
}
}
}
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{PipeGeneric}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}}
}
