% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connections.R
\docType{class}
\name{Connections}
\alias{Connections}
\title{Class to manage the connections with Twitter and YouTube}
\usage{
Connections
}
\description{
The tasks of the functions that the \code{\link{Connections}} class has are to
establish the connections and control the number of requests that have been made
with the APIs of Twitter and YouTube.
}
\section{Constructor}{

\code{Connections$new(keysPath)}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{keysPath:}}{
(\emph{character}) path of the .ini file that contains the keys.
}
}
}
}
}

\section{Details}{

The way to indicate the keys of YouTube and Twitter has to be
through the configuration file that contains the following structure:

\strong{[twitter]}

ConsumerKey = \emph{<<consumer_key>>}

ConsumerSecret = \emph{<<consumer_secret>>}

AccessToken = \emph{<<access_token>>}

AccessTokenSecret = \emph{<<access_token_secret>>}

\strong{[youtube]}

app_id = \emph{<<app_id>>}

app_password = \emph{<<app_password>>}
}

\section{Note}{

Fiels of unused connections will be automatically ignored by the platform.
}

\section{Methods}{

\itemize{
\item{\bold{getTwitterToken:}}{
gets the Twitter token ID.
\itemize{
\item{\emph{Usage:}}{
\code{getTwitterToken()}
}
\item{\emph{Value:}}{
value of \code{twitterToken}.
}
}
}

\item{\bold{startConnectionWithTwitter:}}{
is responsible of establishing the connection to Twitter.
\itemize{
\item{\emph{Usage:}}{
\code{startConnectionWithTwitter()}
}
}
}

\item{\bold{checkRequestToTwitter}}{
function in charge of handling the connection with Twitter.
\itemize{
\item{\emph{Usage:}}{
\code{checkRequestToTwitter()}
}
}
}

\item{\bold{startConnectionWithYoutube}}{
function able to establish the connection with YouTube.
\itemize{
\item{\emph{Usage:}}{
\code{startConnectionWithYoutube()}
}
}
}

\item{\bold{addNumRequestToYoutube}}{
function that increases in one the number of request to YouTube.
\itemize{
\item{\emph{Usage:}}{
\code{addNumRequestToYoutube()}
}
}
}

\item{\bold{checkRequestToYoutube}}{
handles the connection with YouTube.
\itemize{
\item{\emph{Usage:}}{
\code{checkRequestToYoutube()}
}
}
}

\item{\bold{getNumRequestMaxToYoutube}}{
gets the number of maximum requests allowed by YouTube API.
\itemize{
\item{\emph{Usage:}}{
\code{getNumRequestMaxToYoutube()}
}
\item{\emph{Value:}}{
value of number maximun of request to YouTube.
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{keys:}}{
 (\emph{list}) the keys of Twitter and YouTube.
}
\item{\bold{numRequestToYoutube:}}{
 (\emph{numeric}) indicates the number of requests made to YouTube.
}
\item{\bold{numRequestMaxToYoutube:}}{
 (\emph{numeric}) indicates the maximum number of requests with YouTube.
}
\item{\bold{connectionWithYoutube:}}{
 (\emph{logical}) indicates if the connection has been established with YouTube.
}
\item{\bold{connectionWithTwitter:}}{
 (\emph{logical}) indicates if the connection has been established with Twitter.
}
\item{\bold{twitterToken:}}{
 (\emph{Token}) token to establish the connection to Twitter.
}
}
}

\seealso{
\code{\link{ExtractorTwtid}}, \code{\link{ExtractorYtbid}}
}
