% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{train}
\alias{train}
\title{Train Boltzmann Bayes model}
\usage{
train(object, method = "pseudo", naive = FALSE, verbose = 1,
  fixL = FALSE, ...)
}
\arguments{
\item{object}{Object of class \code{bbl} containing training data.}

\item{method}{\code{c('pseudo','mf')} for pseudo-likelihood maximization or
mean field.}

\item{naive}{Naive Bayes. Equivalent to using \code{method = 'mf'} and
\code{eps = 0} in \code{\link{mlestimate}}.}

\item{verbose}{Verbosity level. Relays it to \code{\link{mlestimate}}
with one level lower.}

\item{fixL}{Use predictor level sizes \code{L} from
\code{object@predictors}. If \code{FALSE}, \code{L} is inferred
from \code{object@data}. Intended for cases where this function
is called from \code{\link{crossval}}.}

\item{...}{Other parameters for \code{\link{mlestimate}}.}
}
\value{
\code{object} with slots \code{h}, \code{J}, and \code{lz} filled.
}
\description{
Perform inference on data provided and store parameters
}
\details{
Use \code{data} stored in \code{bbl} object as the training data,
performs either \code{pseudo} or \code{mf} inference for each response
group, and stores the model parameters in slots \code{h} and \code{J}.
This function is a driver of \code{\link{mlestimate}} for \code{bbl} objects.
}
\examples{
titanic <- freq2raw(as.data.frame(Titanic), Freq='Freq')
model <- bbl(data=titanic, y='Survived')
model <- train(model, method='pseudo')
model@h
model@J[[1]]
}
