% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findFile.R
\name{.findFile}
\alias{.findFile}
\title{Find Recent File Information}
\usage{
.findFile(folder = ".", file = "*.*", n = 1, fileNameOnly = TRUE)
}
\arguments{
\item{folder}{folder (i.e., directory to look in, can use relative path )}

\item{file}{file (can use wildcards, e.g., "*.csv")}

\item{n}{number of files to return (e.g., value of 1 returns most recent
file, value of 'all' returns all files)}

\item{fileNameOnly}{logical field, if TRUE only return file name}
}
\value{
returns file name as a character string
}
\description{
Find recent file information based on folder and file name (allows for wildcard
structure)
}
\details{
This function is used to search a selected directory for information
  about the most recently modified files in that directory. The default
  setting searches the current working directory. Relative directory
  addresses can be used. The default settings returns the name of the most
  recently modified file. Employing wildcards in the file argument can narrow
  the file search, e.g., "*.csv" will only return comma delimited files.

  The default setting for the argument, n (of 1), will only return a single
  file. This value can be increased to any number (2, 3,...) to change the
  maximum number of files returned; or the argument can be set to 'all' to
  return all files. Setting the argument, fileNameOnly, to FALSE will result
  in returning additional file meta data related to file size, modified
  date/time and create date/time.

  The results are in descending order of modified date/time.
}
\examples{
# name of most recently modified file
\dontrun{
.findFile()         # current directory
.findFile("..")     # one directory up
#
# list of files and common attributes one directory up
.findFile(folder="..", file="*.*", n=2, fileNameOnly=FALSE)      
                                                       #two most recent files
.findFile(folder="..", file="*.*", n="all", fileNameOnly=FALSE)  #all files
}
}
\keyword{internal}
