% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{QWstacked}
\alias{QWstacked}
\title{Stream Water Quality}
\format{
Data frame with 46 rows and 22 columns\cr
\tabular{lll}{ 
Name \tab Type \tab Description\cr\cr
agency_cd \tab character \tab Agency code\cr
site_no \tab character \tab USGS station number\cr
sample_dt \tab Date \tab Sample date\cr
sample_tm \tab character \tab Sample time\cr
sample_end_dt \tab Date \tab Sample end date\cr
sample_end_tm \tab character \tab Sample end time\cr
sample_start_time_datum_cd \tab character \tab Time zone datum\cr
tm_datum_rlbty_cd \tab character \tab Time datum reliability code\cr
coll_ent_cd \tab character \tab Collecting agency code\cr
medium_cd \tab character \tab Sample medium code\cr
tu_id \tab character \tab Taxonomic unit code\cr
body_part_id \tab character \tab Body part code\cr
parm_cd \tab character \tab Analyte parameter code\cr
remark_cd \tab character \tab Remark code for the result\cr
result_va \tab character \tab Numeric value of the result\cr
val_qual_tx \tab character \tab Result value qualifier code\cr
meth_cd \tab character \tab Lab method code\cr
dqi_cd \tab character \tab Data-quality indicator code\cr
rpt_lev_va \tab character \tab Reporting level\cr
rpt_lev_cd \tab character \tab Reporting level type\cr
lab_std_va \tab character \tab Lab standard deviation\cr
anl_ent_cd \tab character \tab Analyzing agency code\cr
} Note: all concentrations in the
column result_va are in milligrams per liter as phosphorus.\cr
}
\source{
Data retrieved from NWISWeb
(\url{https://nwis.waterdata.usgs.gov/mn/nwis/qwdata}) on 2012-04-06. The
format of water-quality data is often retrieved by result--each row
represents the data for a single analyte. Note that many columns are part of
the generic data retrieval and do not pertain specifically to these data.
}
\usage{
QWstacked
}
\description{
Selected water-quality data for Judicial Ditch 64 near Mentor, Minnesota
(SW4), USGS station number 05078470 for calendar year 2003.

From smwrData.
}
\examples{

data(QWstacked)
# Plot the data for whole-water phosphorus
with(subset(QWstacked, parm_cd == "00665"), plot(sample_dt, result_va))
# Overlay the data for dissolved phosphorus (should be smaller values)
with(subset(QWstacked, parm_cd == "00666"), points(sample_dt, result_va, col='red'))
}
\keyword{datasets}
