% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.lcens.R
\docType{methods}
\name{as.lcens}
\alias{as.lcens}
\alias{as.lcens,lcens,missing,missing-method}
\alias{as.lcens,numeric,missing,missing-method}
\alias{as.lcens,numeric,numeric,missing-method}
\alias{as.lcens,numeric,numeric,logical-method}
\alias{as.lcens,numeric,numeric,character-method}
\alias{as.lcens,numeric,missing,logical-method}
\alias{as.lcens,numeric,missing,character-method}
\alias{as.lcens,qw,missing,missing-method}
\alias{as.lcens,qw,numeric,missing-method}
\alias{as.lcens,character,missing,missing-method}
\title{Left-censored Data Conversion}
\usage{
as.lcens(values, detlim, censor.codes)

\S4method{as.lcens}{lcens,missing,missing}(values, detlim, censor.codes)

\S4method{as.lcens}{numeric,missing,missing}(values, detlim, censor.codes)

\S4method{as.lcens}{numeric,numeric,missing}(values, detlim, censor.codes)

\S4method{as.lcens}{numeric,numeric,logical}(values, detlim, censor.codes)

\S4method{as.lcens}{numeric,numeric,character}(values, detlim, censor.codes)

\S4method{as.lcens}{numeric,missing,logical}(values, detlim, censor.codes)

\S4method{as.lcens}{numeric,missing,character}(values, detlim, censor.codes)

\S4method{as.lcens}{qw,missing,missing}(values, detlim, censor.codes)

\S4method{as.lcens}{qw,numeric,missing}(values, detlim, censor.codes)

\S4method{as.lcens}{character,missing,missing}(values, detlim, censor.codes)
}
\arguments{
\item{values}{numeric values representing "raw" values. Missing values
are permitted. A vector of character strings is allowed when the remark code is
combined with the value; blank values are treated as missing values, any other value
is converted to a missing value with a warning. See \bold{Examples}.}

\item{detlim}{the corresponding detection limit of the sensor. Missing values
are permitted. Detection limits are required for each non-missing value in \code{values};
they will be imputed if missing. The imputation scheme is fairly sophisticated, see
Lorenz (in preparation) for details, so it is better to set to missing, rather than
provide an arbitrary detection limit.}

\item{censor.codes}{optional codes indicating a left-censored value. If class
"logical," then \code{TRUE} indicates left-censored. If class "character,"
then "<" indicates left-censored and anything other than "" or " " generates
a warning.}
}
\value{
An S4 object of class "lcens." These objects are the basis for the
analysis of left-censored data.
}
\description{
Converts data to a left-censored data (\code{lcens}) object: various methods.
}
\note{
All methods force \code{values} to be no less than the corresponding
\code{detlim}. All \code{values} that are less than \code{detlim} are treated
as left-censored values at \code{detlim}. This ensures unbiased analytical results.
}
\examples{

## The first value is censored at 2
as.lcens(c(1,3), 2)
## Set the first value to censored at that level and the detection limit is
# carried forward
as.lcens(c(1,3), censor.codes=c("<", ""))
# For combined remark and values:
as.lcens(c("<1", "1", "<1", "1", "2"))

}
\references{
Lorenz, D.L., in preparation
}
\seealso{
\code{\link{as.mcens}}
}
\keyword{internal}
\keyword{manip}
\keyword{methods}
