% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlexTableRenderer.R
\docType{class}
\name{FlexTableRenderer}
\alias{FlexTableRenderer}
\title{R6 class that converts a table to a flextable from the `flextabler` package.}
\format{
\code{\link{R6Class}} object.
}
\description{
The `FlexTableRenderer` class creates a representation of a table using
the `flextable` package.  See the Output vignette for more details.
}
\examples{
# This class should not be used by end users.  It is an internal class
# created only by the BasicTable class.  It is used when converting to a
# flextable.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FlexTableRenderer$new()}}
\item \href{#method-writeToCell}{\code{FlexTableRenderer$writeToCell()}}
\item \href{#method-writeBorder}{\code{FlexTableRenderer$writeBorder()}}
\item \href{#method-asFlexTable}{\code{FlexTableRenderer$asFlexTable()}}
\item \href{#method-clone}{\code{FlexTableRenderer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new `FlexTableRenderer` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableRenderer$new(parentTable)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentTable}}{Owning table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-writeToCell"></a>}}
\if{latex}{\out{\hypertarget{method-writeToCell}{}}}
\subsection{Method \code{writeToCell()}}{
Write a value to a cell, optionally with styling and cell merging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableRenderer$writeToCell(
  ft = NULL,
  rowNumber = NULL,
  columnNumber = NULL,
  totalRowCount = NULL,
  totalColumnCount = NULL,
  value = NULL,
  applyStyles = TRUE,
  baseStyleName = NULL,
  style = NULL,
  mapFromCss = TRUE,
  mergeRows = NULL,
  mergeColumns = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ft}}{The flextable to write to.}

\item{\code{rowNumber}}{The row number of the cell where the value is to be
written.}

\item{\code{columnNumber}}{The column number of the cell where the value is to be
written.}

\item{\code{value}}{The value to be written.  Since the flextable is created
from a data frame, this argument can be omitted.}

\item{\code{applyStyles}}{`TRUE` (default) to also set the styling of the cell,
`FALSE` to only write the value.}

\item{\code{baseStyleName}}{The name of the style from the table theme to apply
to the cell.}

\item{\code{style}}{A `TableStyle` object that contains additional styling to
apply to the cell.}

\item{\code{mapFromCss}}{`TRUE` (default) to map the basictabler CSS styles to
corresponding Excel styles, `FALSE` to apply only the specified xl
styles.}

\item{\code{mergeRows}}{If the cell is to be merged with adjacent cells, then an
integer or numeric vector specifying the row numbers of the merged
cell.  NULL (default) to not merge cells.}

\item{\code{mergeColumns}}{If the cell is to be merged with adjacent cells, then
an integer or numeric vector specifying the column numbers of the
merged cell.  NULL (default) to not merge cells.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The updated flextable definition.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-writeBorder"></a>}}
\if{latex}{\out{\hypertarget{method-writeBorder}{}}}
\subsection{Method \code{writeBorder()}}{
Write the borders of a cell.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableRenderer$writeBorder(
  ft = NULL,
  rowNumber = NULL,
  columnNumber = NULL,
  totalRowCount = NULL,
  totalColumnCount = NULL,
  border = NULL,
  borderLeft = NULL,
  borderRight = NULL,
  borderTop = NULL,
  borderBottom = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ft}}{The flextable to write to.}

\item{\code{rowNumber}}{The row number of the cell where the border is to be
written.}

\item{\code{columnNumber}}{The column number of the cell where the border is to be
written.}

\item{\code{totalRowCount}}{The total number of rows in the table.}

\item{\code{totalColumnCount}}{The total number of columns in the table.}

\item{\code{border}}{The border to be applied to all sides of the cell (unless
a border is specified using the other arguments).}

\item{\code{borderLeft}}{The border to apply to the left side of the cell.}

\item{\code{borderRight}}{The border to apply to the right side of the cell.}

\item{\code{borderTop}}{The border to apply to the top side of the cell.}

\item{\code{borderBottom}}{The border to apply to the bottom side of the cell.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The updated flextable definition.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-asFlexTable"></a>}}
\if{latex}{\out{\hypertarget{method-asFlexTable}{}}}
\subsection{Method \code{asFlexTable()}}{
Convert table to a flextable table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableRenderer$asFlexTable(applyStyles = TRUE, mapStylesFromCSS = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{applyStyles}}{`TRUE` (default) to also set the styling of the cells,
`FALSE` to only write the value.}

\item{\code{mapStylesFromCSS}}{`TRUE` (default) to map the basictabler CSS styles to
corresponding flextable styles where possible, `FALSE` to apply only the
specified ft styles.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableRenderer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
