% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableOpenXlsxRenderer.R
\docType{class}
\name{TableOpenXlsxRenderer}
\alias{TableOpenXlsxRenderer}
\title{A class that renders a table into an Excel worksheet.}
\format{\code{\link{R6Class}} object.}
\value{
Object of \code{\link{R6Class}} with properties and methods that
  render to Excel via the openxlsx package
}
\description{
The TableOpenXlsxRenderer class creates a representation of a table in an Excel file using the openxlsx package.
}
\section{Fields}{

\describe{
\item{\code{parentTable}}{Owning table.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new table renderer, specifying the
  field value documented above.}

  \item{\code{writeToCell(wb=NULL, wsName=NULL, rowNumber=NULL,
  columnNumber=NULL, value=NULL, applyStyles=TRUE, baseStyleName=NULL,
  style=NULL, mapFromCss=TRUE)}}{Writes a value to a cell and applies styling
  as needed.}
  \item{\code{writeToWorksheet(wb=NULL, wsName=NULL, topRowNumber=NULL,
  leftMostColumnNumber=NULL, outputValuesAs="value", applyStyles=TRUE,
  mapStylesFromCSS=TRUE)}}{Output the table into the specified workbook
  and worksheet at the specified row-column location.}
}
}

\examples{
# This class should not be used by end users.  It is an internal class
# created only by the BasicTable class.  It is used when rendering to Excel.
library(basictabler)
tbl <- qtbl(data.frame(a=1:2, b=3:4))
library(openxlsx)
wb <- createWorkbook(creator = Sys.getenv("USERNAME"))
addWorksheet(wb, "Data")
tbl$writeToExcelWorksheet(wb=wb, wsName="Data",
                         topRowNumber=1, leftMostColumnNumber=1,
                         applyStyles=TRUE, mapStylesFromCSS=TRUE)
# Use saveWorkbook() to save the Excel file.
}
