% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableCellRanges.R
\docType{class}
\name{TableCellRanges}
\alias{TableCellRanges}
\title{A class that manages cell ranges (e.g. for merged cells).}
\format{\code{\link{R6Class}} object.}
\usage{
TableCellRanges
}
\value{
Object of \code{\link{R6Class}} with properties and methods that help
  manage cell ranges.
}
\description{
The TableCellRanges class contains a list of cell ranges and provides
basic utility methods such as finding intersecting ranges to support
the functioning of the BasicTable class.
}
\section{Fields}{

\describe{
\item{\code{parentTable}}{Owning table.}

\item{\code{ranges}}{A list of cell ranges.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new object to manage cell ranges.}

  \item{\code{addRange(rFrom, cFrom, rSpan=NULL, cSpan=NULL, rTo=NULL,
  cTo=NULL)}}{Add a cell range to the list of cell ranges.}
  \item{\code{findIntersectingRange(rFrom, cFrom, rSpan=NULL, cSpan=NULL,
  rTo=NULL, cTo=NULL)}}{Find a cell range that intersects with the
  specified cell range.}
  \item{\code{deleteRange(r, c)}}{Delete the cell range covering the
  specified cell.}
  \item{\code{asList()}}{Get a list representation of this style.}
  \item{\code{asJSON()}}{Get a JSON representation of this style.}
}
}

\examples{
# TableCellRanges objects are never created outside of the BasicTable class.
# For examples of working with merged cells, see the Introduction vignette.
}
\keyword{datasets}
