% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_stats.R
\name{mlb_stats}
\alias{mlb_stats}
\title{\strong{MLB Stats}}
\usage{
mlb_stats(
  stat_type = NULL,
  player_pool = NULL,
  game_type = NULL,
  team_id = NULL,
  position = NULL,
  stat_group = NULL,
  season = NULL,
  league_id = NULL,
  sport_ids = NULL,
  sort_stat = NULL,
  order = NULL,
  limit = 1000,
  offset = NULL
)
}
\arguments{
\item{stat_type}{Stat type to return statistics for.}

\item{player_pool}{There are 4 different types of player pools to return statistics for a particular player pool across a sport.
Acceptable values include: All, Qualified, Rookies, or Qualified_rookies}

\item{game_type}{Game type to return information for a particular statistic in a particular game type.}

\item{team_id}{Team ID to return information and ranking for a particular statistic for a particular team.}

\item{position}{Position to return statistics for a given position. Default to "Qualified" player pool
Acceptable values include:
\itemize{
\item P
\item C
\item 1B
\item 2B
\item 3B
\item SS
\item LF
\item CF
\item RF
\item DH
\item PH
\item PR
\item BR
\item OF
\item IF
\item SP
\item RP
\item CP
\item UT
\item UI
\item UO
\item RHP
\item LHP
\item RHS
\item LHS
\item LHR
\item RHR
\item B
\item X
}}

\item{stat_group}{Stat group to return information and ranking for a particular statistic in a particular group.}

\item{season}{Year to return information and ranking for a particular statistic in a given year.}

\item{league_id}{League ID to return statistics for a given league. Default to "Qualified" player pool.}

\item{sport_ids}{The sport_id(s) to return information and ranking information for.}

\item{sort_stat}{Sort return based on stat.}

\item{order}{Order return based on either desc or asc.}

\item{limit}{A limit to limit return to a particular number of records.}

\item{offset}{An offset to returns i+1 as the first record in the set of players.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   total_splits \tab integer \cr
   season \tab character \cr
   num_teams \tab integer \cr
   rank \tab integer \cr
   games_played \tab integer \cr
   ground_outs \tab integer \cr
   air_outs \tab integer \cr
   runs \tab integer \cr
   doubles \tab integer \cr
   triples \tab integer \cr
   home_runs \tab integer \cr
   strike_outs \tab integer \cr
   base_on_balls \tab integer \cr
   intentional_walks \tab integer \cr
   hits \tab integer \cr
   hit_by_pitch \tab integer \cr
   avg \tab character \cr
   at_bats \tab integer \cr
   obp \tab character \cr
   slg \tab character \cr
   ops \tab character \cr
   caught_stealing \tab integer \cr
   stolen_bases \tab integer \cr
   stolen_base_percentage \tab character \cr
   ground_into_double_play \tab integer \cr
   number_of_pitches \tab integer \cr
   plate_appearances \tab integer \cr
   total_bases \tab integer \cr
   rbi \tab integer \cr
   left_on_base \tab integer \cr
   sac_bunts \tab integer \cr
   sac_flies \tab integer \cr
   babip \tab character \cr
   ground_outs_to_airouts \tab character \cr
   catchers_interference \tab integer \cr
   at_bats_per_home_run \tab character \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_link \tab character \cr
   player_id \tab integer \cr
   player_full_name \tab character \cr
   player_link \tab character \cr
   player_first_name \tab character \cr
   player_last_name \tab character \cr
   league_id \tab integer \cr
   league_name \tab character \cr
   league_link \tab character \cr
   sport_id \tab integer \cr
   sport_link \tab character \cr
   sport_abbreviation \tab character \cr
   position_code \tab character \cr
   position_name \tab character \cr
   position_type \tab character \cr
   position_abbreviation \tab character \cr
   splits_tied_with_offset \tab list \cr
   splits_tied_with_limit \tab list \cr
   player_pool \tab character \cr
   type_display_name \tab character \cr
   group_display_name \tab character \cr
}
}
\description{
\strong{MLB Stats}
}
\examples{
\donttest{
  try(mlb_stats(stat_type = 'season', stat_group = 'hitting', season = 2021))
}
}
