% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_schedule_games_tied.R
\name{mlb_schedule_games_tied}
\alias{mlb_schedule_games_tied}
\title{\strong{Find game_pk values for professional baseball games (major and minor leagues) that are tied}}
\usage{
mlb_schedule_games_tied(season = 2021, game_type = "S")
}
\arguments{
\item{season}{The season for which you want to find game_pk values for MLB games}

\item{game_type}{game_type to return schedule information for all tied games in a particular game_type\tabular{ll}{
   game_type_id \tab game_type_description \cr
   S \tab Spring Training \cr
   R \tab Regular Season \cr
   F \tab Wild Card Game \cr
   D \tab Division Series \cr
   L \tab League Championship Series \cr
   W \tab World Series \cr
   C \tab Championship \cr
   N \tab Nineteenth Century Series \cr
   P \tab Playoffs \cr
   A \tab All-Star Game \cr
   I \tab Intrasquad \cr
   E \tab Exhibition \cr
}}
}
\value{
Returns a tibble that includes game_pk values and additional
information for games scheduled or played\tabular{ll}{
   col_name \tab types \cr
   date \tab character \cr
   total_items \tab integer \cr
   total_events \tab integer \cr
   total_games \tab integer \cr
   total_games_in_progress \tab integer \cr
   game_pk \tab integer \cr
   link \tab character \cr
   game_type \tab character \cr
   season \tab character \cr
   game_date \tab character \cr
   official_date \tab character \cr
   game_number \tab integer \cr
   public_facing \tab logical \cr
   double_header \tab character \cr
   gameday_type \tab character \cr
   tiebreaker \tab character \cr
   calendar_event_id \tab character \cr
   season_display \tab character \cr
   day_night \tab character \cr
   scheduled_innings \tab integer \cr
   reverse_home_away_status \tab logical \cr
   inning_break_length \tab integer \cr
   games_in_series \tab integer \cr
   series_game_number \tab integer \cr
   series_description \tab character \cr
   record_source \tab character \cr
   if_necessary \tab character \cr
   if_necessary_description \tab character \cr
   status_abstract_game_state \tab character \cr
   status_coded_game_state \tab character \cr
   status_detailed_state \tab character \cr
   status_status_code \tab character \cr
   status_start_time_tbd \tab logical \cr
   status_reason \tab character \cr
   status_abstract_game_code \tab character \cr
   teams_away_split_squad \tab logical \cr
   teams_away_series_number \tab integer \cr
   teams_away_league_record_wins \tab integer \cr
   teams_away_league_record_losses \tab integer \cr
   teams_away_league_record_pct \tab character \cr
   teams_away_team_id \tab integer \cr
   teams_away_team_name \tab character \cr
   teams_away_team_link \tab character \cr
   teams_home_split_squad \tab logical \cr
   teams_home_series_number \tab integer \cr
   teams_home_league_record_wins \tab integer \cr
   teams_home_league_record_losses \tab integer \cr
   teams_home_league_record_pct \tab character \cr
   teams_home_team_id \tab integer \cr
   teams_home_team_name \tab character \cr
   teams_home_team_link \tab character \cr
   venue_id \tab integer \cr
   venue_name \tab character \cr
   venue_link \tab character \cr
   content_link \tab character \cr
   is_tie \tab logical \cr
   description \tab character \cr
   teams_away_score \tab integer \cr
   teams_away_is_winner \tab logical \cr
   teams_home_score \tab integer \cr
   teams_home_is_winner \tab logical \cr
   reschedule_date \tab character \cr
   reschedule_game_date \tab character \cr
   rescheduled_from \tab character \cr
   rescheduled_from_date \tab character \cr
   resume_date \tab character \cr
   resume_game_date \tab character \cr
   resumed_from \tab character \cr
   resumed_from_date \tab character \cr
   events \tab list \cr
}
}
\description{
\strong{Find game_pk values for professional baseball games (major and minor leagues) that are tied}
}
\examples{
\donttest{
  try(mlb_schedule_games_tied(season = 2021))
}
}
