% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logisticfit.R
\name{logisticfit}
\alias{logisticfit}
\title{Fits a Logistic growth model on Aoristic data}
\usage{
logisticfit(
  x,
  niter = 1e+05,
  nburnin = 50000,
  thin = 10,
  nchains = 4,
  rPrior = "dexp(1/0.001)",
  mPrior = "dunif(1,z)",
  rSampler = NULL,
  mSampler = NULL,
  parallel = FALSE,
  seeds = 1:4
)
}
\arguments{
\item{x}{A ProbMat class object}

\item{niter}{Number of MCMC iterations. Default is 100,000.}

\item{nburnin}{Number of iterations discarded for burn-in. Default is 50,000.}

\item{thin}{Thinning interval}

\item{nchains}{Number of MCMC chains}

\item{rPrior}{A string defining prior for the growth parameter r. Default is 'dexp(1/0.01)'.}

\item{mPrior}{A string defining prior for the point of maximum growth rate m. Default is 'dunif(1,z)', where 'z' is the number of time-blocks.}

\item{rSampler}{A list containing settings for the MCMC sampler for the parameter 'r'. Default is null and employs nimble's Default sampler (RW sampler).}

\item{mSampler}{A list containing settings for the MCMC sampler for the parameter 'm'. Default is null and employs nimble's Default sampler (RW sampler).}

\item{parallel}{Logical specifying whether the chains should be run in parallel or not.}

\item{seeds}{Random seed for each chain. Default is 1:4.}
}
\value{
A \code{fittedLogistic} class object containing the original ProbMat class object, posteriors of the growth rate and midpoint and their MCMC diagnostics (i.e. Gelman Rubin statistic and effective sample sizes).
}
\description{
Fits an exponential growth model to \code{ProbMat} class objects.
}
\details{
The function fits a discrete bounded logistic growth model on the observed data using MCMC as implemented by the nimble package. The Bayesian model consists of two parameters, a growth rate (r) and a midpoint (m) defining the inflection point of the growth curve. Priors of the two parameters can be defined by the arguments \code{rPrior} and \code{mPrior}. In the latter case the object \code{z} is a placeholder for the number of blocks (e.g. the default 'dunif(1,z)` is a uniform across all blocks). Priors are defined by character strings following the syntax used by nimble. Please note that the function returns posterior of the growth rate normalised by the resolution defined in the \code{ProbMat} class object.  MCMC settings such as the choice the sampler, number of iterations, chains, etc can also be specified.
}
